<?php
$my_intransaction = InTransaction::find_by_query("SELECT * FROM in_transaction WHERE user_id =$user->id  ORDER BY date DESC");


?>

<div class="p-2 sm:ml-64 mb-14">
    <nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-cyan-700 border border-cyan-200 rounded-lg bg-cyan-50 dark:bg-cyan-800 dark:border-cyan-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="#"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">Users</a>
                </div>
            </li>
        </ol>
    </nav>
    <div
        class="relative flex flex-col m-3 h-full min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
        <div
            class="relative flex flex-col min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
            <div class="p-6 px-4 pb-0 mb-0 bg-sky-800 border-b-0 rounded">
                <h6 class="mb-0 text-sm text-white">Users</h6>
            </div>
            <div class="flex-auto p-4 pt-6 text-white">
                <hr class="h-px bg-transparent bg-gradient-to-r from-transparent via-black/40 to-transparent" />
                <!-- </div> -->
                <div class="table-responsive" style="font-size: 12px !important;">
                    <table class="table table-flush text-white datatable text-sm " datatable id="datatable-search"
                        style="font-size: 12px !important;">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Email</th>
                                <th>Name</th>
                                <th>Wallet Balance</th>
                                <th>Status</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php
$usersPerPage = 10; // Set the number of users per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1; // Get the current page from the URL
$offset = ($page - 1) * $usersPerPage;

$usersCount = User::count_all();
$pages = ceil($usersCount / $usersPerPage);

$users = User::find_all_limit_offset($usersPerPage, $offset); // You need to implement a method like this

$users = array_reverse($users);

foreach ($users as $usera) {
    $his_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id=$usera->id LIMIT 1");
    $his_wallet = array_shift($his_wallet);
    ?>
    <tr class='hover:bg-sky-300 hover:text-sky-950'>
        <td class="font-normal leading-normal"><?= $usera->id ?></td>
        <td class="font-normal leading-normal"><?= $usera->email ?></td>
        <td class="font-normal leading-normal"><?= $usera->first_name . " " . $usera->last_name ?></td>
        <td class="font-normal leading-normal">₦<?= $his_wallet->balance ?></td>
        <td class="font-normal leading-normal">
            <?= $usera->status == 1 ? '<span class="badge badge-lg bg-gradient-to-tl from-green-600 to-lime-400">Verified</span>' : '<span class="badge badge-lg bg-gradient-to-tl from-red-600 to-rose-400">Not Verify</span>' ?>
        </td>
        <td>
            <a href="./?page=users&sub_service=-user_detail&userah=<?= base64_encode($usera->id) ?>" class="hover:shadow-soft-xs inline hover:scale-105 rounded-lg px-4 py-1 text-white bg-sky-950">View</a>
        </td>
    </tr>
<?php
}
?>


                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

