<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');
$client = new \GuzzleHttp\Client();


function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST);
    if (isset($vin) && !empty($service_type)) {

        $user = User::find_by_id($_SESSION['user_id']);
        if ($user) {

            $service_type = Service::find_by_id($service_type);
            $sub_service = SubService::find_by_id($sub_service_id);



            if (!$service_type) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }
            if (!$sub_service) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }

            $service = $service_type->service_name;
            $service_fee = intval($service_type->service_fee);
            $status = 0;

            $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
            $my_wallet = array_shift($my_wallet);
            $my_wallet_balance = intval($my_wallet->balance);

            if ($my_wallet_balance >= ($service_fee + intval($sub_service->service_fee))) {


                try {

                    $response = $client->request('POST', 'https://api.verified.africa/sfx-verify/v3/id-service/', [
                        'body' => '{"searchParameter":"' . $vin . '","verificationType":"VIN-FULL-DETAILS-VERIFICATION","countryCode":"NG"}',
                        'headers' => [
                            'accept' => 'application/json',
                            'apiKey' => 'D1nvMPuWW8gZWDlnT6kW',
                            'content-type' => 'application/json',
                            'userid' => '1662732332645',
                        ],
                    ]);

                    $responses = $response->getBody();
                    
                } catch (\Throwable $th) {

                    print_r($th->getMessage());
                    echo error_res(false, "03", "Network Error!");
                    exit;
                }




                //   $responses = '
                //                     {
                //                         "responseCode": "00",
                //                         "description": "Successful",
                //                         "verificationType": "VIN-FULL-DETAILS-VERIFICATION",
                //                         "verificationStatus": "VERIFIED",
                //                         "transactionStatus": "SUCCESSFUL",
                //                         "transactionReference": "1628016393774-L6GGXUMP",
                //                         "transactionDate": "1659704055982",
                //                         "searchParameter": "A3F67936J8956H90782",
                //                         "callBackUrl": null,
                //                         "livenessScore": 0.0,
                //                         "paymentRef": null,
                //                         "response": {
                //                             "vin": "A3F67936J8956H90782",
                //                             "country": "NG",
                //                             "state": "Lagos State",
                //                             "lga": "VITORIA ISLAND",
                //                             "document": "Not Available",
                //                             "address": "10, Workbox, Ojora Close, Victoria Island, Lagos, VITORIA ISLAND, Lagos State",
                //                             "occupation": "STUDENT",
                //                             "gender": "Male",
                //                             "photo": "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",
                //                             "id_number": "A3F67936J8956H90782",
                //                             "expiration_date": "Not Available",
                //                             "full_name": "Joe Leo",
                //                             "dob": "2000",
                //                             "first_name": "Joe",
                //                             "last_name": "Leo",
                //                             "phone_number": "0123456789",
                //                             "phone_number2": "Not Available"
                //                         },
                //                         "faceMatch": null
                //                     }';


                $response_std = json_decode($responses);
                // print_r($response_std);



                $service_record = new ServiceRecord;
                $in_transaction = new InTransaction;



                $new_response_std = new stdClass;

                if ($response_std->responseCode == 00 && $response_std->verificationStatus == 'VERIFIED') {
                    $status = 1;

                    $new_response_std->response_code = "00";
                    $new_response_std->detail = "Verification Successful";
                    $new_response_std->data = new stdClass;

                    $new_response_std->data->dob = $response_std->response->dob;

                    $new_response_std->data->firstname = $response_std->response->first_name;
                    $new_response_std->data->surname = $response_std->response->last_name;
                    $new_response_std->data->full_name = $response_std->response->full_name;
                    $new_response_std->data->gender = $response_std->response->gender;
                    $new_response_std->data->photo = $response_std->response->photo;
                    $new_response_std->data->address  = $response_std->response->address;
                    $new_response_std->data->country = $response_std->response->country;
                    $new_response_std->data->state = $response_std->response->state;
                    $new_response_std->data->lga = $response_std->response->lga;
                    $new_response_std->data->occupation = $response_std->response->occupation;
                    $new_response_std->data->phone_number = $response_std->response->phone_number;
                    $new_response_std->data->phone_number2 = $response_std->response->phone_number2;
                    $new_response_std->data->vin = $response_std->response->vin;
                    $new_response_std->data->userid = "";

                    $new_response_std->verification = new stdClass;
                    $new_response_std->verification->status = '';
                    $new_response_std->verification->reference = "";

                    // print_r($new_response_std);
                    // return false;

                    $new_wallet_balance = $my_wallet_balance - $service_fee;
                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                } else if ($response_std->responseCode == 00 && $response_std->description == 'The ID provided is invalid') {

                    $in_transaction->user_id = $user->id;
                    $in_transaction->wallet_id = $my_wallet->id;
                    $in_transaction->search_query = $vin;
                    $in_transaction->amount = $service_fee;
                    $in_transaction->remaining_balance = $new_wallet_balance;
                    // $in_transaction->service = $service;
                    $in_transaction->service = $service_type->service_name;
                    $in_transaction->date = $date;
                    $in_transaction->status = $status;

                    $in_transaction->save();


                    $new_response_std->response_code = "03";
                    $new_response_std->message = "The ID provided is invalid";
                    $service_fee = 50;
                    $status = 0;
                    // $new_wallet_balance = $my_wallet_balance - $service_fee;
                    $new_wallet_balance = $my_wallet_balance - ($service_fee + intval($sub_service->service_fee));

                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;

                    $my_wallet->save();
                } else {
                    echo error_res(false, "01", $response_std->description);
                    exit;

                    //     $new_wallet_balance = $my_wallet->balance;
                    //     $service_fee = 0;
                }




                $in_transaction->user_id = $user->id;
                $in_transaction->wallet_id = $my_wallet->id;
                $in_transaction->search_query = $vin;
                $in_transaction->amount = $service_fee;
                $in_transaction->remaining_balance = $new_wallet_balance;
                // $in_transaction->service = $service;
                $in_transaction->service = $service_type->service_name;
                $in_transaction->date = $date;
                $in_transaction->status = $status;

                if ($in_transaction->save()) {

                    $service_record->user_id = $user->id;
                    // $service_record->service = $service;
                    $service_record->service = $service_type->service_name;
                    $service_record->search_query = $vin;
                    $service_record->response = json_encode($new_response_std);
                    $service_record->in_transaction_id = $in_transaction->id;
                    if ($service_record->save()) {
                        $new_response_std->record_id = $service_record->id;

                        $new_response_std->search_query = $vin;
                        $new_response_std->record_id = $service_record->id;

                        echo (json_encode($new_response_std));
                        exit;
                    } else {
                        echo error_res(false, "03", "Contact Administrator!");
                        exit;
                    }
                } else {
                    echo error_res(false, "03", "Contact Administrator!");
                    exit;
                }
            } else {
                echo error_res(false, "03", "Insufficient wallet balance");
                exit;
            }
        } else {

            echo error_res(false, "03", "Contact Administrator!");
            exit;
        }
    } else {

        echo error_res(false, "03", "Contact Administrator!");
        exit;
    }
} else {
    echo error_res(false, "03", "Contact Administrator!");
    exit;
}