<?php
require_once('../vendor/autoload.php');
require_once('../main_includes/init.php');

$client = new \GuzzleHttp\Client();

if (isset($_POST['amount'], $_SESSION['user_id']) && $_POST['amount'] != 0 && $_SESSION['user_id'] != "") {

    extract($_POST);

    if (intval($amount) < 100) {
        redirect("../user/billing");
        return false;
    }

    $user = User::find_by_id($_SESSION['user_id']);
    if (!$user) {
        header("Location: ../user/billing");
    }

    $amount = $amount * 100;
    $callback = "https://localhost/2plusverify/payment/callback.php?sasd={$_SESSION['user_id']}";
    // printf($callback);
    // return false;
    $fields = '{
        "amount":' . $amount . ',
        "email":"' . $user->email . '",
        "currency":"NGN",
        "initiate_type": "inline",
        "callback_url":"' . $callback . '"
    }';

    $fields = json_encode([
        "amount" => $amount,
        "email" => $user->email,
        "currency" => 'NGN',
        "initiate_type" => "inline",
        "callback_url" => $callback
    ]);
    // print_r($fields);
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api-d.squadco.com/transaction/initiate',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '{
              "amount":' . $amount . ',
              "email":"' . $user->email . '",
              "currency":"NGN",
              "initiate_type": "inline",
              "callback_url":"https://2plusverify.com.ng/payment/callback.php?sasd=' . $_SESSION['user_id'] . '"
              }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'accept: application/json',
            'Authorization: Bearer sk_b53fc8bab69731a0c22a2e18437d2de50c3ccadf'
        ),
            'Authorization: Bearer sk_6756a57bce8ce3a8c9fd697b9af4dac1e6114a16'
    ));



    $response = curl_exec($curl);
    $err = curl_error($curl);
    if ($err) {
        // there was an error contacting the Paystack API
        die('Curl returned error check your Internet connection!: ' . $err);
    }


    $response = json_decode($response);

    if (!$response->success) {

        // print_r($response);

        curl_close($curl);
        redirect("../user/billing");
        return false;
    } else {


        $my_transaction = new MyTransaction;
        $my_transaction->user_id = $_SESSION['user_id'];
        $my_transaction->amount = $amount / 100;
        $my_transaction->reference = $response->data->transaction_ref;
        $my_transaction->status = "Not Varified";
        $my_transaction->date_created = $date;
        $my_transaction->date_updated = $date;
        $my_transaction->method = "Payment Gateway";

        $my_transaction->save();
        curl_close($curl);

        // echo "<pre>";
        // print_r($response);
        // echo "</pre>";
        redirect($response->data->checkout_url);
    }




    // redirect($response->authorizationUrl);



} else {
    header("Location: ../user/billing");
}
