<?php

$services = Service::find_all();
$intransaction = InTransaction::find_by_query("SELECT SUM(amount) as amount FROM " . InTransaction::$db_table . " WHERE status=1");
$intransaction = array_shift($intransaction);

// echo "<pre>";
$total_earned = 0;
$api_charges = 0;
$dev_earned = 0;
$mark_earned = 0;
$mach_earned = 0;
$today_mach_earned = 0;




foreach ($services as $service):
    // print_r($service);

    $parent_intransaction = InTransaction::find_by_query("SELECT * FROM " . InTransaction::$db_table . " WHERE  status=1 AND service='$service->service_name'");
    $parent_intransaction_sum = InTransaction::find_by_query("SELECT SUM(amount) as amount FROM " . InTransaction::$db_table . " WHERE  status=1 AND service='$service->service_name'");
    $parent_intransaction_sum = intval(array_shift($parent_intransaction_sum)->amount);
    
    $today_parent_intransaction_sum = InTransaction::find_by_query("SELECT SUM(amount) as amount FROM " . InTransaction::$db_table . " WHERE  status=1 AND service='$service->service_name' AND DATE(date)='" . date('Y-m-d') . "'");
    $today_parent_intransaction_sum = intval(array_shift($today_parent_intransaction_sum)->amount);
    
    $total_earned += $parent_intransaction_sum;
    $today_total_earned += $today_parent_intransaction_sum;
    
    $mach_percent = (1 - $service->commission);

    $new_p_mach_earn = $mach_percent * $parent_intransaction_sum;
    $today_new_p_mach_earn = $mach_percent * $today_parent_intransaction_sum;
    
    $unit_profit = intval($service->service_fee) - intval($service->api_charge);
    $total_profit = count($parent_intransaction) * $unit_profit;

    $new_profit = $total_profit - $new_p_mach_earn;

    $mach_earned += $new_p_mach_earn;
    $today_mach_earned += $today_new_p_mach_earn;
    
    $dev_earned += (($service->dev_commission) * $new_profit);
    $mark_earned += ((1 - $service->dev_commission) * $new_profit);


    $sub_services = SubService::find_by_query("SELECT * FROM sub_service WHERE service_id = $service->id");
    foreach ($sub_services as $sub_service):

        $child_intransaction = InTransaction::find_by_query("SELECT * FROM " . InTransaction::$db_table . " WHERE  status=1 AND service_id=$service->id AND service='$sub_service->service_name'");
        
        $child_intransaction_sum = InTransaction::find_by_query("SELECT SUM(amount) as amount FROM " . InTransaction::$db_table . " WHERE  status=1 AND service_id=$service->id AND service='$sub_service->service_name'");
        $child_intransaction_sum = intval(array_shift($child_intransaction_sum)->amount);
        
        $today_child_intransaction_sum = InTransaction::find_by_query("SELECT SUM(amount) as amount FROM " . InTransaction::$db_table . " WHERE  status=1 AND service_id=$service->id AND service='$sub_service->service_name' AND DATE(date)='" . date('Y-m-d') . "'");
        $today_child_intransaction_sum = intval(array_shift($today_child_intransaction_sum)->amount);
        
        $total_earned += $child_intransaction_sum;
        $today_total_earned += $today_child_intransaction_sum;

        $c_mach_percent = (1 - $sub_service->commission);
        $new_mach_earn = ($child_intransaction_sum * $c_mach_percent);
        $today_new_mach_earn =  ($today_child_intransaction_sum * $c_mach_percent);
        
        $c_unit_profit = intval($sub_service->service_fee) - intval(0);
        $c_total_profit = count($child_intransaction) * $c_unit_profit;

        $c_new_profit = $c_total_profit - $new_mach_earn;

        $mach_earned += $new_mach_earn;
        $today_mach_earned += $today_new_mach_earn;
        $dev_earned += (($sub_service->dev_commission) * $c_new_profit);
        $mark_earned += ((1 - $sub_service->dev_commission) * $c_new_profit);

    endforeach;
endforeach;
?>

<div class="p-2 sm:ml-64 mb-14">
    <nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-teal-700 border border-teal-200 rounded-lg bg-teal-50 dark:bg-teal-800 dark:border-teal-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="#"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">Analytics</a>
                </div>
            </li>

        </ol>
    </nav>

    <div class="grid grid-cols-1 md:grid-cols-2 mt-3 gap-2 p-2">
        <div
            class="relative flex flex-col stretch break-words bg-emerald-700 shadow-soft-xl rounded bg-clip-border hover:shadow-soft-xs">
            <div class="flex-auto p-4">
                <div class="flex flex-row">
                    <div class="flex-none w-2/3 max-w-full px-3">
                        <div>
                            <!--<p class="mb-3 font-sans font-semibold leading-normal text-white">-->
                            <!--    Earned -->
                            <!--</p>-->
                            <!--<p class="mb-0 font-sans font-semibold leading-normal text-white text-sm">-->
                            <!--    Total Earned-->
                            <!--</p>-->
                            <!--<h5 class="mb-4 text-white font-bold">-->
                            <!--    ₦-->
                            <!--    <?= number_format($total_earned) ?>-->

                            <!--</h5>-->
                             <p class="mb-0 font-sans font-semibold leading-normal text-white text-sm">
                                API Charges
                            </p>
                            <h5 class="mb-4 text-white font-bold">

                                ₦
                                <?= number_format($total_earned - ($dev_earned + $mark_earned + $mach_earned)) ?>

                            </h5>
                            <p class="mb-0 font-sans font-semibold leading-normal text-white text-sm">
                                Today Marchant Earned
                            </p>
                            <h5 class="mb-4 text-white font-bold">
                                ₦
                                <?= number_format($today_mach_earned) ?>

                            </h5>
                            <p class="mb-0 font-sans font-semibold leading-normal text-white text-sm">
                                Marchant Earned
                            </p>
                            <h5 class="mb-0 text-white font-bold">
                                <!--₦ <?= number_format(112450) ?>-->
                                ₦
                                <?= number_format($mach_earned) ?>

                            </h5>
                        </div>
                    </div>
                    <div class="px-3 text-right basis-1/3">
                        <div
                            class="inline-block w-12 h-12 text-center rounded-lg bg-white hover:shadow-soft-xs hover:scale-102">
                            <i class="ni leading-none ni-money-coins text-lg relative top-3.5 text-emerald"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php foreach ($services as $service):
            $parent_intransaction = InTransaction::find_by_query("SELECT * FROM " . InTransaction::$db_table . " WHERE  status=1 AND service='$service->service_name'");
            $parent_intransaction_sum = InTransaction::find_by_query("SELECT SUM(amount) as amount FROM " . InTransaction::$db_table . " WHERE  status=1 AND service='$service->service_name'");
            $parent_intransaction_sum = intval(array_shift($parent_intransaction_sum)->amount);
            $parent_commission = (1 - $service->commission) * $parent_intransaction_sum;

            // print_r($parent_intransaction_sum);
            ?>



            <div class="w-ful max-w-full mb-6  sm:flex-none xl:mb-0 flex flex-col">
                <div
                    class="relative flex flex-col min-w-0 break-words bg-emerald-800 text-white shadow-soft-xl rounded bg-clip-border h-full">
                    <div class="flex-auto p-4">
                        <div class="flex flex-row -mx-3">
                            <div class="flex-none max-w-full px-3">
                                <div>
                                    <p class="mb-0 font-sans font-semibold leading-normal text-sm">
                                        <?= $service->service_name ?>
                                    </p>

                                    <table class="table text-gray-400 overflow-x-scroll" style="font-size: 12px !important;">
                                        <tr>
                                            <th>Service</th>
                                            <th>Unit Cost</th>
                                            <th>%Comm.</th>
                                            <th>Total Used</th>
                                            <th>Total Cost</th>
                                            <th>Commission</th>
                                            <!-- <th>Our 30%</th> -->
                                        </tr>
                                        <tr>

                                            <td>
                                                <?= $service->service_name ?>
                                            </td>
                                            <td>₦
                                                <?= $service->service_fee ?>
                                            </td>
                                            <td>
                                                <?= (1 - $service->commission) * 100 . "%" ?>
                                            </td>
                                            <td>
                                                <?= count($parent_intransaction) ?>
                                            </td>
                                            <td>₦
                                                <?= $parent_intransaction_sum ?>
                                            </td>
                                            <td>₦
                                                <?= $parent_commission ?>
                                            </td>
                                            <!-- <td></td> -->
                                            <!-- <td></td> -->
                                        </tr>
                                        <?php $sub_services = SubService::find_by_query("SELECT * FROM sub_service WHERE service_id = $service->id");
                                        foreach ($sub_services as $sub_service):

                                            $child_intransaction = InTransaction::find_by_query("SELECT * FROM " . InTransaction::$db_table . " WHERE  status=1 AND service_id=$service->id AND service='$sub_service->service_name'");
                                            $child_intransaction_sum = InTransaction::find_by_query("SELECT SUM(amount) as amount FROM " . InTransaction::$db_table . " WHERE  status=1 AND service_id=$service->id AND service='$sub_service->service_name'");
                                            $child_intransaction_sum = intval(array_shift($child_intransaction_sum)->amount);

                                            $child_commission = (1 - $sub_service->commission) * $child_intransaction_sum;

                                            // $child_commission = $commision * $child_intransaction_sum;
                                            // print_r($child_intransaction);
                                            ?>
                                            <tr>
                                                <td>
                                                    <?= $sub_service->service_name ?>
                                                </td>
                                                <td>₦
                                                    <?= $sub_service->service_fee ?>
                                                </td>
                                                <td>
                                                    <?= (1 - $sub_service->commission) * 100 . "%" ?>
                                                </td>
                                                <td>
                                                    <?= count($child_intransaction) ?>
                                                </td>
                                                <td>₦
                                                    <?= $child_intransaction_sum ?>
                                                </td>
                                                <td>₦
                                                    <?= $child_commission ?>
                                                </td>
                                                <!-- <td></td> -->
                                            </tr>
                                        <?php endforeach ?>
                                    </table>
                                    <h5 class="mb-0 font-bold">

                                        <!-- <span
                                                    class="leading-normal text-sm font-weight-bolder text-lime-500">+55%</span> -->
                                    </h5>
                                </div>
                            </div>
                            <!-- <div class="px-3 text-right basis-1/3">
                                <div class="inline-block w-12 h-12 text-center rounded-lg bg-white">
                                    <i class="ni leading-none ni-money-coins text-lg relative top-3.5 text-emerald"></i>
                                </div>
                            </div> -->
                        </div>
                    </div>
                </div>
            </div>

        <?php endforeach; ?>

    </div>










</div>