<div class="p-2 sm:ml-64 mb-14">
    <nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-teal-700 border border-teal-200 rounded-lg bg-teal-50 dark:bg-teal-800 dark:border-teal-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>

            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="#"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">Settings</a>
                </div>
            </li>

        </ol>
    </nav>

    <div
        class="relative flex flex-col m-3 h-full min-w-0 break-words bg-emerald-800 border-0 shadow-soft-xl rounded bg-clip-border">
        <div
            class="relative flex flex-col min-w-0 break-words bg-emerald-800 border-0 shadow-soft-xl rounded bg-clip-border">
            <div class="p-6 px-4 pb-0 mb-0 bg-emerald-800 border-b-0 rounded">
                <h6 class="mb-0 text-sm text-white">Services Settings</h6>
            </div>
            <div class="flex-auto p-4 pt-6 text-white">
                <hr class="h-px bg-transparent bg-gradient-to-r from-transparent via-black/40 to-transparent" />
                <!-- </div> -->
                <div class="table-responsive" style="font-size: 12px !important;">

                    <table class="table text-white">
                        <thead>
                            <th>#</th>
                            <th>Services</th>
                            <th>Display Status</th>
                            <th>Availability Status</th>
                            <th>Actions</th>
                        </thead>
                        <tbody>
                            <?php $services = Service::find_all();
                            $i = 1;
                            foreach ($services as $service): ?>
                                <tr class='hover:bg-emerald-400 hover:text-emerald-950'>

                                    <td>
                                        <?= $i ?>
                                    </td>
                                    <td>
                                        <?= $service->service_name; ?>
                                    </td>
                                    <td>
                                        <?= $service->display == 1 ? '<span class="badge bg-success">Diplaying</span>' : '<span class="badge bg-danger">Not Diplaying</span>'; ?>
                                    </td>
                                    <td>
                                        <?= $service->status == 1 ? '<span class="badge bg-success">Available</span>' : '<span class="badge  bg-danger">Not Avail</span>'; ?>
                                    </td>

                                    <td>
                                        <button data-id="<?= $service->id ?>"
                                            class="toggle-display text-xs p-2 bg-gray-500 rounded">Display Toggle</button>
                                        <button data-id="<?= $service->id ?>"
                                            class="toggle-status text-xs p-2 bg-emerald-950 text-white rounded">Status Toggle</button>
                                    </td>
                                </tr>

                                <?php $i++;
                            endforeach; ?>
                        </tbody>
                    </table>

                </div>

            </div>

        </div>
    </div>
</div>






<script>
    $('.toggle-display').click(function () {

        var service_id = $(this).data('id')


        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "../main_includes/components/toggle_display.php",
            data: {
                service_id
            },
            success: function (response) {
                // console.log(response)
                if (response.response_code == "00") {
                    iziToast.success({
                        title: 'Done',
                        message: response.message,
                        // color: "yellow",
                        position: "topRight",
                        balloon: true,
                        onClosing: function () {
                            window.location.reload()

                        }
                    });
                } else {
                    iziToast.error({
                        title: 'Error',
                        message: response.message,
                        // color: "yellow",
                        position: "topRight",
                        balloon: true

                    });
                }
            }

        })

    })
    $('.toggle-status').click(function () {

        var service_id = $(this).data('id')

        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "../main_includes/components/toggle_status.php",
            data: {
                service_id
            },
            success: function (response) {
                // console.log(response)
                if (response.response_code == "00") {
                    iziToast.success({
                        title: 'Done',
                        message: response.message,
                        // color: "yellow",
                        position: "topRight",
                        balloon: true,
                        onClosing: function () {
                            window.location.reload()
                            // console.log(window.location)
                        }
                    });
                } else {
                    iziToast.error({
                        title: 'Error',
                        message: response.message,
                        // color: "yellow",
                        position: "topRight",
                        balloon: true

                    });
                }
            }

        })

    })
</script>