<?php
require_once('../vendor/autoload.php');

$client = new \GuzzleHttp\Client();
$date = Date("c");


define('API_BASE', 'https://api.myidentitypass.com');
// define('API_BASE', 'https://sandbox.myidentitypass.com');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

extract($_POST);
if (isset($bvn) && !empty($bvn)) {

    $user = User::find_by_id($user_id);
    if ($user) {
        $service_type_id = 20;
        $service_type = Service::find_by_id($service_type_id);

        if($service_type->status == 0){
            echo response(res(500, 'Sorry! Service temporary not available.', ''));
            exit;
        }
        
        $service = "BVN Verification (API) v1";
        $service_fee = intval(50);
        $status = 0;

        $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
        $my_wallet = array_shift($my_wallet);
        $my_wallet_balance = intval($my_wallet->balance);

        if ($my_wallet_balance >= $service_fee) {

            try {

                $response = $client->request('POST', 'https://api.prembly.com/identitypass/verification/bvn', [
                    'body' => '{"number":"' . $bvn . '"}',
                    'headers' => [
                        'accept' => 'application/json',
                        // 'x-api-key' => 'live_sk_YmvFR1W37jxaaygVFYmiATnzqTPRYcPgOS8sxOx',
                        'x-api-key' => 'sandbox_sk_78fQCZsQOGBEAXyxk58h9XDBK9cEAI0OrywNAJV',
                        'content-type' => 'application/json',
                        // 'app-id' => 'e183e0bc-d262-4c90-8a75-caa3ff4a87d8',
                        'app-id' => '1a4393bc-8135-4263-8c1b-d2e376cc464b',
                    ],
                ]);

                $responses = $response->getBody();
            } catch (\Throwable $th) {
                // echo error_res(false, "03", "Server Error Contact Administrator!");
                echo response(res(400, 'Bad Request', 'This value does not match the required pattern.'));
                exit;
            }

            $response_std = json_decode($responses);

            // print_r($response_std);
            $service_record = new ServiceRecord;
            $in_transaction = new InTransaction;

            if ($response_std->response_code == "00") {
                $status = 1;
                $new_wallet_balance = $my_wallet_balance  - $service_fee;
                $my_wallet->balance = $new_wallet_balance;
                $my_wallet->date_updated = $date;
                $my_wallet->save();
            } else {
                $new_wallet_balance = $my_wallet->balance;
                $service_fee = 0;
            }



            $in_transaction->user_id = $user->id;
            $in_transaction->wallet_id = $my_wallet->id;
            $in_transaction->search_query = $bvn;
            $in_transaction->amount = $service_fee;
            $in_transaction->remaining_balance = $new_wallet_balance;
            $in_transaction->service = $service;
            $in_transaction->date =  $date;
            $in_transaction->status = $status;

            if ($in_transaction->save()) {

                $service_record->user_id = $user->id;
                $service_record->service = $service;
                $service_record->search_query = $bvn;
                $service_record->response = $responses;
                $service_record->in_transaction_id = $in_transaction->id;
                if ($service_record->save()) {
                    // $response_std->record_id = $service_record->id;

                    $response_std->search_query = $bvn;
                    if ($response_std->response_code == '00') {
                        $data = new stdClass;
                        $data->bvn_data = $response_std->data;
                        $data->verification = $response_std->verification;

                        echo response(res(200, $response_std->detail, $data));
                    } else {
                        $data = new stdClass;
                        // $data->bvn_data = $response_std->bvn_data;
                        $data->verification = $response_std->verification;

                        echo response(res(400, $response_std->message, $data));
                        // echo (json_encode($response_std));
                    }


                    // echo (json_encode($response_std));
                    exit;
                } else {
                    echo response(res(500, 'Internal Server Error', ''));

                    // echo error_res(false, "03", "Contact Administrator!");
                    exit;
                }
            } else {
                echo response(res(500, 'Internal Server Error', ''));

                // echo error_res(false, "03", "Contact Administrator!");
                exit;
            }
        } else {
            echo response(res(402, 'Insufficient wallet balance', ''));

            // echo error_res(false, "03", "Insufficient wallet balance");
            exit;
        }
    } else {
        echo response(res(401, 'Unauthorized', ''));

        // echo error_res(false, "03", "Contact Administrator!");
        exit;
    }
} else {
    echo response(res(400, 'Bad Request', ''));

    // echo error_res(false, "03", "Contact Administrator!");
    exit;
}