<?php include "main_includes/header.php"; ?>


<body class="bg-white">


    <section class="bg-white">
        <div class="flex flex-col items-center justify-center px-6 py-8 mx-auto md:h-screen lg:py-0">
            <a href="#" class="flex items-center mb-6 text-2xl font-semibold text-gray-900 text-white">
                <div class="rounded w-20 h-20">
                    <img src="assets/img/favicon.png">
                </div>
            </a>
            <div class="w-full rounded-lg shadow border md:mt-0 sm:max-w-md xl:p-0 bg-emerald-800 border-emerald-700">
                <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                    <h1 class="text-xl font-bold leading-tight tracking-tight text-gray-900 md:text-2xl text-white">
                        Forgot Password
                    </h1>

                    <p class="mb-0 text-gray-400">Enter your Email Address to recieve Password Reset Link</p>
                    <!-- <div class="msg"></div> -->


                    <form class="space-y-2 md:space-y-2" id="form" method="POST" role="form">
                        <div>
                            <label for="email" class="block mb-2 text-sm font-medium text-gray-900 text-white">Your
                                email</label>
                            <input type="email" name="email" id="email"
                                class="bg-gray-50 border py-2 border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 bg-gray-700 border-gray-600 placeholder-gray-400 text-white focus:ring-blue-500 focus:border-blue-500"
                                placeholder="your@email.com" required="">
                        </div>


                        <div class="text-center">
                            <button type="submit" name="login" id="login"
                                class="inline-block w-full px-6 py-3 mt-6 mb-0 font-bold text-center text-white uppercase align-middle transition-all bg-transparent border-0 rounded-lg cursor-pointer shadow-soft-md bg-x-25 bg-150 leading-pro text-xs ease-soft-in tracking-tight-soft bg-gradient-to-tl from-blue-600 to-teal-400 hover:scale-102 hover:shadow-soft-xs active:opacity-85">Send
                                Reset Link</button>
                        </div>
                    </form>

                    <div
                        class="p-2 text-gray-400 px-1 pt-0 text-center bg-transparent border-t-0 border-t-solid rounded-b-2xl lg:px-2">
                        <p class="mx-auto leading-normal text-sm">
                            Don't have an account?
                            <a href="sign-up"
                                class="relative z-10 font-semibold text-transparent bg-emerald-500 bg-clip-text">Sign
                                up</a>
                            <br>
                            <a href="sign-in"
                                class="relative z-10 font-semibold text-transparent bg-emerald-500 bg-clip-text">Sign-in</a>
                        </p>

                    </div>

                </div>
            </div>
        </div>

    </section>
    <?php
    include "./main_includes/loader_out.php";
    ?>
</body>
<!-- plugin for scrollbar  -->
<!-- <script src="assets/js/plugins/perfect-scrollbar.min.js" async></script> -->
<!-- main script file  -->
<!-- <script src="assets/js/soft-ui-dashboard-tailwind.js?v=1.0.4" async></script> -->
<script src="./assets/iziToast-master/dist/js/iziToast.js"></script>

<script>
    $(document).on('submit', '#form', function (e) {
        e.preventDefault()

        $.ajax({
            dataType: "json",
            url: 'main_includes/components/send_reset_pass.php',
            method: "POST",
            data: $(this).serialize(),
            success: function (res) {
                console.log(res)
                if (res.status) {


                    iziToast.show({
                        title: 'Sent',
                        message: "Password Reset Link Sent",
                        color: "green",
                        position: "center",
                        balloon: true,
                        onClosing: function () {
                            // document.location.href = response.uri

                            document.location.href = "sign-in"
                        }
                    });

                    // swal({
                    //     Title: "Password Reset Link Sent",
                    //     icon: "success",
                    //     button: "Okay",
                    //     text: "Password Reset Link Sent"
                    // }).then((confirm) => {

                    //     document.location.href = "login"
                    // })
                } else {
                    iziToast.show({
                        title: 'Sorry',
                        message: "Password Reset Link Not Sent",
                        color: "yellow",
                        position: "topRight",
                        balloon: true,

                    });


                }


            }
        })

    })
</script>

</html>