<?php
require_once('../../vendor/autoload.php');
require_once('../init.php');
$client = new \GuzzleHttp\Client();

// define('API_BASE', 'https://api.myidentitypass.com');
// define('API_BASE', 'https://sandbox.myidentitypass.com');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST);
    if (isset($nin) && !empty($service_type)) {

        $user = User::find_by_id($_SESSION['user_id']);
        if ($user) {

            $service_type = Service::find_by_id($service_type);

            // print_r($service_type);
            // return false;

            if (!$service_type) {
                echo error_res(false, "03", "Service Not Avilable, Contact Administrator!");
                exit;
            }

            $service = $service_type->service_name;
            $service_fee = intval($service_type->service_fee);
            $status = 0;

            $my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
            $my_wallet = array_shift($my_wallet);
            $my_wallet_balance = intval($my_wallet->balance);

            if ($my_wallet_balance >= $service_fee) {

                try {

                    $accessToken="9jabbeerr12qdw:@09040773100J";
                    $postdata = array(
                    'planId' => "44",
                    'trkid' => $nin,
                    'ref' => "",  
                    );
                    $endpoint="https://bidayyibanurun.com.ng/api/nin/pulling.php";
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $endpoint);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt(
                    $ch, CURLOPT_HTTPHEADER, [
                    "Content-Type: application/json",
                    "Authorization: Token ".$accessToken."",
                    ]
                    );
                    $responses = curl_exec($ch);
                    curl_close($ch);
                    // $responses = $response->getBody(); 
                    
//                     $responses = '{
//   "success": true,
//   "message": "Verification Successfull",
//   "data": {
//     "nin": "58859505164",
//     "firstname": "LAWAN",
//     "middlename": "",
//     "lastname": "ISAH",
//     "gender": "m",
//     "address": "NAYI NAWA WARD DAMATURU",
//     "face": "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",
//     "town": "DAMATURU",
//     "state": "YB",
//     "message": "Personalization For Long Slip Only Succeeded",
//     "trackingid": "2AWZLKQ528001VC",
//     "status": "1",
//     "surname": "ISAH",
//     "trackingId": "2AWZLKQ528001VC",
//     "tracking_id": "2AWZLKQ528001VC",
//     "residence_Town": "DAMATURU",
//     "residence_lga": "",
//     "residence_state": "YB",
//     "residence_AdressLine1": "NAYI NAWA WARD DAMATURU",
//     "photo": "\/9j\/4AAQSkZJRgABAgAAAQABAAD\/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL\/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL\/wAARCAHSAV4DASIAAhEBAxEB\/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL\/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6\/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL\/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6\/9oADAMBAAIRAxEAPwDVbrSD71K3WkH3qsoc\/QUnelfoKTvQMDS\/wikNL\/CKQDDS+lIaX0pgOPSkFKelIKBCijvQKO9IYhpaQ0tMBKWkpaQAaSlNJTAYaVetIaVetIBWooaigANIaU0hpgJ2pD2pe1Ie1AC0tJS0AO7Ug6Gl7Ug6GgApD1paQ9aAF70jdKXvSN0oAQdKd2po6U7tQIaKSlFJQAtJS0lAxwooFFAhKkH3RUdSD7ooAQ9aQdaXFIRQArHIppbmlpDigY48ijnHSk7UmeKQCkZpKKKYDyaQGkBpKBDxRnmkGMUh60himjNIaQUwHUtNoHNIBSRRSEUCmA00q8UpFANIAJopCBRxQAppDSGkpgLSHtRRQAtLSUtAC9qB0pCeaMZoAWkPWiigBe9I3Sg0h6UAA6U7tTM0uaBAKSjNFAC0lGaKBjhRSA0poEJUg+6Kjp2TigBSTSZ4ozScetADhikOM0nFJQMeenFNoB4ozSAXtSdqTNGaYC0UgNGaQDxScU3NLmmAE56UopuaAcUAOPFGcCkLZpueaAHdTRSGigB1NzSZopAGaKTNGaAFpDR+NJnFMBcUo6U3dQDSAf0opuaXrQAtL0ptGaAHCim5ozQA6kPSk70MeKYCClpAwNLQAlBpCaTdQIUnmlFMPLA5oJ9DQMkHWnDpUQbNPzQIcOtO7VHnmlBoASikpaBiikNFFIBaSiigAzSHrS0hpgFLSUtIA7UUmaWmAUUUmaAFopM0ZoAU0lITRnNACk0mRTTxSE+1IB1JmjtSZpgLnig0lKeaAAc0CgGk4pAO6UtN7UtAC0UUUAKDRmkFFACihj8tA6U1uhoAap5p5OKYKcaYCE03NONNPFABmikpaAF6GnhuOlR0DjvQBJmlBqPPzU+gBu\/NOB96j6UZoAlpajDcUoNAD6KbuxTs5oAKSlpDSAO1LSDPpRnApgFGaTNJuz2oAdmkpM0p4oAXkUhNGTSZoAM0e9BNVrq+trNMzzog9zSAsHnpTea5q78a2EORAjzH1HArLm8bXcnEFuiD35ouFmzuhmmnFedP4r1ZzgOF+gqu\/iDVZAd1ywHtS5h8rPTc4Apc5NeWjVtSbGbuQD609Nb1ONsrdv6c0cyHys9PyKMVwFv4v1GDiUJKB1yMZroNO8WWV5tSXMEh7N0ouTZnQ54ozTVdXQMpDA9CD1pxpgLmikHSgnFACjNBJoBpDQAo6daCflo4pD93FADAafTKfmgBCe9NPNOPIpppgIc9qWkzRgUALzS0maUUgA0oNBIpKAEooopgFKDTc0uc0AOzS7qZnFLmgB4agmo80oNAD80uajzS5oAcaTIpM0cmgBc4pe1NJ7UZOKQDqguryCzhMszhFHc1T1XWINLgLyMC5HC55rznVNWudVnLSOQn8KA8ChuwWub2reM3lJisBtXvI39K5ae5muZS00jOx7k0xU2k5z0pyRn720kCocjRQEVRu5\/WpI87vapFj3Yz09KkWLd8o9eahyNFEicjflR1FRhcHaT9andAHyvRaYyq5LdzS5h8o1CSdvYd6VTgkKCaljQbNoH1NMUGMsqjNF9Q5RpJYHNMwFGSvJqUxHaD370rJujIzyKdxcpe0vXbzS3yrF4u6Mc13Wla3a6pFmNgsneMnkV5kVIiyecUsU8tvMskTMjDoRVpmconr+c0lc74f8RLqEYguCFuFH\/fVdCPrVmdh2aQmkooAcDRTQKWgbE70uaYetOzQJBmg9KSlzkUDsRnNO3DFB5qM0BYlzS1GDTs8UwsOpQabS5pCG54oHSkAOKUGmAUo6UneloAWim0opALRRRTAKXNNpaACjOOKKKACs3WNXh0q2LswMh+6nvU2pahFpto08h6dB6mvNL6+n1W9eaX1+UegqW7DUbiXl3PqFw007EljkDsKgEJzkDvVyOHgHFWUhyQaycjojDQqLFuYDPP0qyIsACraRoBnHNIyBhzwazcjRRK3kKAMU9Il3VINo7c0ArUttmiiiMW4JYMOKrywbBgLwaueZjimGVTxTVxOxTClWx0zViNMRkYGT0p4VJT6GpEjCn2ou0NJFRkADKabLFiJSvXvV8xg8GmtEGXFLmYOmZzQMEAxyeaa0OF+bn0rXMO5QR1HFJ9nXAyKtTM3Awo2lgkEiEqynIIrvfDmuf2hGYZTiZeee4rkLmHJwo61BbTy2F2k6k5U9q1jI55wPV80maqadfRX9ok0Z69R6GrfFaGY6k6im5pc0AJ3pabn5qXd2oAUUhFKKQ0ANppp4Oe1MNADgMUtNB4pw5oBi0tIeBQKBDQaUHio91LmmBICKM1HmjOaAJSwoBqMUgOGoAmzRmoieetG7igCSjNR7qAeaBkmc1HPMsMTO5wqjJNLu5rlPGGqGKBLJGwz8t9KQjC1vV5NVvSefIQ4Rf61VhjAOaqx9cAE571djzgDHSspSOmnEtqFPSpl4HFVg2OO9OD4HJ5rJs2SJi\/NNL81C0vXHWnRkHk9allpDs0opq\/MeKlSMk\/ShDZHKhINVTG+7rWkyeoNNEIJ6VaMnuV4oyvJq4o45FKkfOMcVOIz6UmNEG3kUpQdKnZcY4pDH6VBomRgYqTqMEUbSCDSt1z3pWGyCW3DHIHNZ15ZsR07dq2BzTJY9wP0q4uxlKKZU8NaobC++zyn93IcfQ136kMMjpXld3G0M4deuc13nh3Uxfaau85lj4eumLucko2Zs0Dim0oNUQNY80gNKetFADgaMnFNzTj0oATNIfajpSE0AA4ozg5oFKRmgTHE8CkDU0njFIDigBAR6UZqMEj6UueR6VQD+aWmZ4pc8UgHUd6QGg9aAFooozQAA807NMDClz60ANmkEULyNwFGTXl2oXT3+oSzyHILEL9K7fxTffZdJdUPzyHaK4FB8nvUTdi4K4sWd3sKuIe4quinFTocDmsWzpiiTdzRuJNNJyeKTJP1qDZIfvAOKerZOOgpgXkZ6U7GD7UiieMANgVeiTPaqcK45rQgIIFCEx5QnGB0o2c8irSpkcVKtuGOWq0ZlZYe+Kk8r1q4iAcCneXvBxjPvRYLlVYQRz0oa3G3KgYq2I+w7UyT5VPrQ0Fyi0IAJHSq7KAautkj3qtIDzuqSrkWQOlBbIphxmjpU9RmXqKKccc0eHtROnaoA5PlSfK3t6GrN1Fv5HasWeMxvuzyDmt4M56kep6uH3DI5Bp3asrQb1b3S4ZAcsBtb8K1K2OYaetKOKRu1FAAetPHSmd6UdKAFIpppc5pDQAA0uTTaUUABB60lOPSm0BYgzRmiiqEGTTs8U2jNADt1KG5plHNAEmaM0zPFJmkBJkUhamZpCeCTQM43xdcGW9igBwEGTWEoIqfVp\/tOsTsCeGwKiUHFZSZrTRIowKfTFz1pwrFs6YoU0nTmlp200mapCq3epkBY5xUaJzk1MvysKQx8YOevFXYQd33sVWUbSTipYy2Mr1oA1YQO7Zq0NoAXrVKDLqp71diU+Z04q0ZyRIinPpRtYHIb9Km25PpTGB7UyBrMw5zxUMkmeqkD1pzZOc0zJxg81LAjVQxODz70yRSwxj8alZQR05ph+VetDBFB12tTDU8wyM1BmoNOhFIcj6VmXC\/MzFRitV\/umqU6hlPHFXBmclcueD7kpeS25PysNw5rtx0rzjSZPI1qBgcKTg16MOnWulM5JKzEY80ooPWgUyQpRSUdKAFPFNzSkZ5ooAQUvejNGaAA0lKTmkoBlYGndqYOxp2asQvFIeaM0hNIBcigmkzQSKAHZ4ppaml6YTSGPDc02RysTn0BpM1DdsFtZSf7poA86lffeyt1y5qZW7AVTiIMz\/AFNXUGOe1YyNqYqjHWnZpKcATWTOqKHLzTwGpYo+RVlIdxwBUM0WpAu4HgVYTtuXrU4txgcdKlSHccYqWy1EjRd\/vUypg9Ksx2nzADvV0WWxM4oTbE9CK2UcYq9FEd3PSnwW6BRkYB71cWIF1xWsUzKTItlMaPk9q0REvTvTHgyKqxFzJdAOtRNsHBq\/NCVU8Vmy9SASPaobsVy3GnAPtTNynOcUwxsTxmoirDrRzIORiyYIxVZwBUjZzUTZNGgajCARUEuOeKsEVFMuV4poGZUoMUqOFIIYEGvRrOTzrWOQd1Brz26GBmu30C4NxpEDEglRtJHtW8DkqLU0Wo7UGirMgpaSigBc0hPNFFABiijNGc0AFJml7Uh6UAVe1KDTaM4qyR1IcUUGgYcAUjGlPSo2NIEGaTdim84pueaQx240S4aFwem00zPNKCCMHpQDPN0H+kyjHRiKtA8UXMPk6rcLjA3ZFKuOOKxmb0hV6VKoIGTTccU4tkYFYM6oolEigcDmp45cYqpnA7U5t7DI4pWKvY1UuUcY6VMlyiHqK58yunY\/WgTnGT396bihKTOpTUkjIJG6taG9huoAANp964NJWP8AFV23vWilXDH3oTSBps6g3HlsQDmrcdyrYzxWEkxlznirUUuRtPShSYWubwmyMk89jSi5jz1P41l+bhMhqpzXpUH1FNyFynRM8UnU9ahaC2cnpmuUk1R0fIeqc2szFtyuaV7hZo66WGJOARVRliLnLD6VzB1SdycucVJHfTnhcketLlDmZrTCME4YYFV2AxwRj2qBI3l+ZyQTS7Hjf71Gwbg1Rt04qZgCOvNQuMU0xMz71TsPHWuj8IHGnyDOcPXO3+TEMevWuh8JYFjIMc7810QOaqdGelApM8UDpWhgKcUU1s9qd2oAKKKKAGsxHSmo3OKVlJpQuBQA7PFJ1oApcUAUzSZpAaKskXNFJRmgBSaiZs09jgVCTzmkxoM009aXcKYzCkMjubhLeMu54H61Sj122Zgr5QHuao+JJ2itk2jPNc8lyJFwwAJrOUrM1hBSRra5EBqQmU5SRc5HSqCjvUayyYEbSMyDlQTnFSLUt3LgrOw4yelJvAo25prYXnGT6VjY6VKxMmWIwKuwwI\/3nA\/GsoMx5Ztq+lSR31rC43tmjlBTRvf2daOnMyfnWbd6SEUtDMr+wNXItb0lYRvDc\/7NOjm0u\/OI3C56EHBquUhzT2OdLyRNg9amiuCTjvWjf6LNEhkibzkPtyKxAXil2sCOe9JopSOgt52KgZrVgYlcCuftH5FdLp4DD3rO+tjW2hJyE5zms65JBJBramhynPSsa9VVBwaJaOwlsZFxIQ3PWqhkLHCjmrEqM7EjmoXR4l3Fgn4VSQnKxYt7Z5MZrVgsnUZUcVzsd5Gr\/vLlufQ1qWuo2XAad1HZiTinymbmjSZJYx0qBpypw1I7rIMwXRP\/AALIqrI1xH\/rAHHqKnl1KUkWd+TkUM5IzUMTA9KlYgCmtxvYr3WGg6d63\/CmRYv6b+9c7dZMJA4rStdTa1so7SyQl8ZeRh0J9K2i7anLOLbsjryaF6VzEGrXEMwE0xbP8JNdLFIHjVgPvDNaKVzKVNx3H00Hk06kqiBw+tLTVGO1LmgAJoxmg0A8UALikFFFAGeCc0tJxjpSg8VZIA80tHaigBjnjFQk1K\/WompMaIyaaaVjjmoy3pSKMjX499oD6GuXMDfK2OM9a7e7iE9uyH0rmZEaON43GNp4rGaZ00WnGxWTG7HpUqjiol+\/0qyi5xWd9DRrUac4qKTeASo5q6I89qd5II5FQ3Y0Uboxo0Z5x5+dueam1XT48JNZkEd171fe1DdqWOyOeDirU0Q6Ohh2mnzzOCVIXPOe1dqbbSjYRwR2bXDquCyKVIP1qraac4K4I+prWihNvzuJPoOBTcrkRpqJi7rrSkZlE5jJ\/wBVKMjH1rKvZkvJ1kVNp9MVvarf\/L5QIZz2HOKw4rZi5ZhUuRooXJIsoRzXQ6ZOFIyaxBHgjitCyGGBNZOWp0KOhvzT7oyM1i3OW71oSHcmBVN0z2qea7FylcT20Vvyvzk4zjNUbi0t5Z1M80jxk5IWMqBV1E+zXIkxle4rTd1uol2Nt44rZO60MXGz1OR1qwtVEc9jgqOGUdaykN1Ofs+JXUnKpk4zXaNp8rk7RG3sQOaha3nilB8pVPqOK0jOxhOld6FRvDxsdLSdrkx3BGSmaqW1zdbsNmRa2Xs5LklpB+Oc1Lb6cIT9386hyNI02kVI1YjJXFStEevpV5oVPamsgArO+pq1oUVjDuqv0p9xMIYyIFGR39Kc2A3PFMmUGMhep6VTbJjG5hS+ZJeRlmJJavS7IFbWPJ\/hFcPDZF9ViiIORgmu8iXYoX0rakYYnSyJaMUgNLWxy2DrRilAzR3oATFLiig0AFJRRQBmnpgUZxQCcdKM+orQkd368UZyaTsBTsYFAEbnmoXbmpHHNQsMmpY0NJ4JqLOKe3AIqMmkhiEisnV4Pl8zHBrVwCaiuYfOtnTvjIoauiotp3OYSI7d46VLERUau0e+I9z3qSLg1zNWR2X1LS9KlQDvUStxUqnJFYSOiGxOsampVhA5pkeB1NK9yIxxzUopk3nCMfMcYqlcak7gpD+dVppWmYjoKWKPBwBWl7IjkuyNY9vzNyx6mpVUsSe1PkTauDUe8BcZqHctWHY+arMIwRUCEdamRwrD3qGWi6pbHWgc0K44x3FGVHekN6AUyORUe1reTfGee\/pVmNlfirP2PzUyGq1foZyaIIp4p8fwP3HrVlEb+9kH1rOms2Vucg+tLDcTRnYwBHqBWin3M3DqjSCoCcimvsxxSxfvRzkE05rY4POamQKxVYZNRyYweKmKFTzUEpAqVuORQuM4NPtB+8VnGVU5qe3jWW5RG5BPapPIU3TRxngHFa2uQpcqLek2e+7e9kGS3Irb43VFbRCCFVHbrUpAzmuqKsjhqS5mO4ooFL2qjMMd6KKAPWgBcUYoBpcigTExxzTTTjSUwMsE5owTzSnPajmrELjIpO\/Wk6UhJoAa+TURPapWPy8dahJNSxoYwqPGalbOKi5zzSsMQDmlAwc0CnEcVQXOb1m2EN1vHCtz+NVYm9a6DVbbz7M+q81zanFYzRvCV0WQ9SpIc8GqnJFSIcdK5ZI7ISL4lwPemE7uahVhnmp1G4+1Z6mtxFTcelXI4hCNzD6U2JVB+YYxS30+yDK96tIlyM+6meWbCD8qalvIealtlXG5jya04\/JA681Mn2KiupQjjK\/eq1HDuxUu2Jn61eghQ7emKg0ulsV\/IKgVHIjY4rqRp1tJCh3gZHJzVafTraLgyg\/jVchn7RXscsVmVtwNa+nXj4AbhuhFWTZ2\/VZhVZ41ikBVgcGnFtMJWaNSREuFyAAaz5bTacgVOjsjLheKsq6uMMvNaNJmSk0UY2aNsHBFWfOXbjHNEkYHIFVZcAZqGtB6Mr3EoDmqcjlqnmIwTVJn560RV2EnoTQy\/Z38zOWxgL71q6RbksZnHT+dZaxb9hQ5Y8V0ltF5Nuid8c10QV2ctWVolik70DNDdRW5yDgaXNNFLQAopaTPaigB1IRRRupgBppzTjSUAZZo\/GkpKskdSYpDRzQMa\/SojUr9KiNSxoYTmm45px+lJzmi42LtA7UEU6gnimK4xlDLj14NcxqFobWY8fKx4NdPnNZurx77XdjO05qZIqLszngxAp6n3qPPXilU81yyR1xkWFPOKsxEHj0qkDVmFsfWs3odMXdGihBIB5FV9TBEO0dOtSRyDbz1qKZt4OeaXMO1zLWfzIzHu2sOM1D5N4p\/dXee+GNWZbdSc7aWOAHgCqTRDi2QRanLFJ5dxwf7w6VtWmoE4IfIrObTBNweadBo95bkmIbk9DSdnsUpSidGuouY+G4qm1zLM5WNhu9zVeC0uDw\/yiraWaxYPU9zUWY3K5k3FxfxSFfOAxV7THuJpFErZA71akRGHzKGx0yKIQEYYGPequidToQVeMADnFV3YxvycUyGQ7QQabcNu6HmqvchqxMbjK9apTy+9RSTbRgVWaTfwTUspIJpOvpVYHc2ac5J4qWwhE10iNyp61cUROVi7pEZlmz1RK6ID0pkUEcKbY0Cj0FSAV0xVjhnPmYhDUhB9afQRVEDQO+TTsUAc0ox2pgO20YpRRQAnGaCtLjNGKAEwMUnFKetN6UAZQpCMGpNuKNuaskZilwaXbTgKAImHB4qu2fSrTA5qFhSY0Q0gPNSYpNvOakph9KQ04j0pvOKokYR6VXuk32zjHarRJqNhuGDzQwRx7LhiKQHBqxfRmK6cAd6rVzzR1U3oSA96mjbHNVgetG48c1i0dMZF7zuwpwfAqmr96cZMjA6UuUvmJndSKajYOaYo3dKcFVeppWFcuwXAUgmtm1vY2G3pWDE6JyE3H3q1HLBKQGUxsf4hRYrmXU0by7jjbIaqn2vzOQpxSfY4UZZJJvMHYCrSzKqERqi\/UUWuS5IqmUtxjFPRzkZ6VJuBHzqre4pv7v+FwfY0WsK9ywk2zFEk5IzVUggHmoWm3DaTQkK5K75ziovMz0HNR7vTpTS\/NDQ0yTOT1rT0WMm6zjOBWWgLGui0OLbEznqa1prUwrS0Niiiiug4xaQ0CloATtThTe1OHSmA4UHrRiigANLk03nNKRxzQIQjnrTSKdjjrSFfegDPxxRjFOxgUlaCEIFIcClooEM4JqNhUxHFRkZNJoaZCQKae1PZQKYRUjuKQKbinUhpgRkYBqE5Bqd\/aomHNJgYesQkuJAOO9ZPSunvIRNAyd+ormnQo5UjkVlJG0H0G0lOxxTayZ0JiZOcY4qRTgVCxNJuY8bsfhRYbdifzSMjtUZm7lqgaKfP3wQfapYbN3GWbNGiBSbJBdbOhqRLzjOaFsAcZU81MLCHogJobRSix8V\/wDJgmo31Ag8NWhFpkaxbymfakWzBkCxwcn2pXG4+ZTXUJMfdbFL9swfutmtVNLdlPmHbjtSPboDt29O9AmrGWt5cyMQkZ2juacN8jg9+9XWRV+VOKiJCN0o0J1HlQABio8Zal35OKmhjJbOKktkkaHaOOtdTYwiG2RR6ZNZGn2nmzAsPlHNdABhcCt6aOSq+g7FFIKWtDEUUd6AOad0piG0q9KMjNLmmgF7UYzSAmnZ4pAGOPejPFGTSYzQAtLtpoXH1p4waYGXkZ5peKQigVoSLj0ox7UCkNIBD0qI5NS0hFAEDDNMPSpGFRNxSaGJnihjxTSwFMZ+KQxGPvUbHvSM4FMLZqWMGrLvrTMgkUcd60Scc0xsMMVO6KjozDMXNQyREduK15YADuXH0qFosisHodCfUxn4pqcnmrd1bkZOKpjg0IpstKCRxginBynSoFYjvTzIx9DQUmaNre+W3IBHoa1EureSMEoobPauY8xwfu8VNE07fdSkVdM6T7ZD7YqQ6ska\/Kin3xXO\/Z7wkcCpP7PuyOGoC6NOTUWlJyeKgM+eB+dQJp03ViTVhbZk6ikw0AHJ9zUdwuBU6pt5JqNwWPFITRFboWbNa9pas5wBUdhaZ+ZuAOprf8Psk2txQKodSCTSFJjreMQoFHbrVkciuql0S0lJzEUP+yaozeGmHMEx9gwreNVWOWUG9TFxRVmbS72AkNAxA7rzVYgrwwKn0NaKSZnytbjhRikHSlxVoQhHNLnFJjmlxSAUHJ6U8U1eKdQAUmKXNLmmAmKXFFFMTM3FKAO9JSVYgOM8UhpD1pCelACikJFNaQCoXl9KGOw53ANVZJeopHkNV2YnmpbGkPMlMLjFRlwKYZADUMqxIWpheljimuXxDGzk9gK37DwncTbXuWCL12jrUOaRSizngGkOEBY+wq7BpU8g3ONi+9dhHo8FomI4wMdz1qK4gAjOKxlV7GippbnG6tbR2lgzxklwc5rLtriO6UbTiTuprb8R7YdOO\/rI2AK4k7kYMrEMOhFQpc2pbVtjemgLqayJ7fax4Iq7aawjAR3PDdnq1PEsybkIIPcU9UCZg4Ip6DmnzRmNiCKj3YplxZbijXvzWraxKAOBWNHJk9a1bWYFQPSkaaGukCvjFWVtwBwBVWCYADmr6zqQBxmqSM2yN4gi9BVGYjBqzdXKLxurJuLpfwpMEMkbnirVnbCQF34UdSazfNDSe1WDcMUEYPyjt61Nhtly5vQR5UPCdCfWtbwYT\/wkEBXqQQK51VrV0W4+xalBMpxtcUdBPVHsLFt2GH41bhQN2FR3BDKkyj5WUGpIHzgjisE7isWGiTuv5VRuNOtZsh4EP4VrbdyA0otQ65NO7QtOpyFz4at5Mm3Zoj6dRWLdaJfWeSU8xfVa9Bkt8dqiKk8YFaRrNEuCZ5iWwcMCD70oPpXe3uiWl2CZIgG\/vLwa5668MSx5a3kDD+63Wt41kzGVJmKBmlzT5rae1O2WJl98cVGCDW6aZm1YdnilowKXpTEFFGaKYGdmmk+1DOBiq8k2OKpsViRmAqBpMVG0pqJn9alyKSJGckdetRFz600momapuUkK7Zqu7YJ9KsRwy3DhIkLMfQdK6fSPCIkZXvG99tRKaRajc5ez027v32wRMR\/ePSup0\/wZGu1rxzI3XavSuwt7KK3QJFGAo9BU5jG3gYJrmlWfQ1VNGda6fBaKBFEoA9BVgxZBx1q6sRQAYBFDIo+o9KxbuaJIz3tmIwx4qlLYLzitd9zcLxVUK7zbafQT3PM\/G8flzW8Y6cmuLkTBxivR\/iHaFI7efHCNg4rz913VpDRAzPmT0pbe7mtSNjZXuh6VNIlQNF6mtExNGjHNDejBGyT0NQXUYi4zzVVBg8GpZWkdRk5I7mixLuhiSHNXIrrygO9UA4RSGFSROrd6dhqoaqaiS4Aq22pFQMNz61zwcpNxzUjzYjznJ9Kdh86NSe+LDJPWqM12WICtxUK75sKinPc1o2WlrGN0p3N6UttxNuWw+2hJAZs89qthcZp2AuAB0pQvOTUXLSsKoq1Bww+tVx7VPEeRj1qWymj3rT4BLolszcnyh\/Klt1Qkq2ARU+lDdotuOmYh\/KqEhMcuc8E4rna1ITNdI8Dg1KmSKp2kpb71XY3G4jGDQDK1xwQT0qA7WIIq9cx74yKzgfLfYaBIl2qR0NQTQ7ucYxVsoWTK9aTb8uGppjMqWBXUq6q49CM1lXOgWUxJQNC3t0roXRQTioGjB61pGbRLSe5yFz4fuofmjxMn+z1rNkjeJyrqVPuMV3pQj7pNQywxTDbNCr\/UVtGvbczlSXQ4akJOa6a48OxSEtbybD\/dbkVj3Ok3ds+GiLZ6FeRXRGrFmLg0ci0pJ4qJ3PWmbqSqvcdgJzyaazYpcMxAUc9q3tI8LXN\/Ir3CmKLrjualyS3KSbMGOOadwkSM7Hstb1h4UnlIe8Plqedo6121noVtpkQ8uMbu2RzVyO3Od0gzXPKr2NIwMjTtGitlAgjVffFbMVoqrhhzR5scTYXk07z5GIwMZrFts1SSJBHtAUDg0jRjGfSpUjaMhyc5pk7EjANQO5WdmbjtTkhIHHJNPjUuavxQ7eaBN2KbW+F461VMOJBW2Yd6ZArOngaOTNMm+pzPirSxqGh3CAZcAsPqK8aZNpwRgjqDX0NIm5WUjhhXi\/ivS203WplCYjc7lx\/Kqg+hZzTpUTR5q26g1EU5xWoWKpTHapEweDTnSmqMGmJoZJECTxxUXkKDxxVwjIpNoppkuJDFahiSTVuGzjHOBTUXmrCEYpuY1BFmJEQYUCp\/uDnqagTAGcGpe2T0rNybNEgPPNOU560zNOGQKVyrEgOKni+ZgB1JqtuAq3YAy30ES9WkUY\/GpE0fQmlx7NJtl7+Uv8qqSxq5dD1B4rTgTy7WNe6qB+lUHH+kZPGayZkivCzRsFzWpFwM5zVae243rTrV8jaajqVpYvN86HHWsadGE+a2E649KrTRAyE+tUStCBZTEyq\/QjrVo7WXtzVa6h3QgjqBVeCfJEbnGO9LqUSzL83y9qYsfc9DVokt1AI9aeiJ0zk+lO4imUz0qJ4h3rTeMEcDFVzbhjkVVxGa0J7UzMi9Olaj2xAquIyOi5p+gbnhua09O0K81FgUjKof4jXUaN4NSLbLefO3XYOldghtbGELtVSOiqK6pVf5TJQ7mLo3g+3s0WaQBpPUiugJgtIgiBd3qaozalLJ8sQ2rVbJc5Ykv71hJtmiVi5LKgbLEk\/pUE0zlcKeKjGf4uT60jcDrUjQQqHbkVfjUJwRyelQ2kW7JNWwhJ+Y\/SgGwGVGW5z0qGYY6dTVhVYH5ulQSKTJ0pMES2kQPUVoBOMCorZAI145q5HHubB7UJEyeoKmyPHeqd1bs6ZFaEpAquXzxg4oEZPlncFIrivH2jtdWQuY0+eE5P0r0CdcPkDpVa4tknjaKRdyuuDRsy0z5xYbWIPSmMPQ10Hi3Q30LWJIShELndEfUVz9bLXUtakeOaYyVKetOwCKYECjsalVSB0ppXmpY+uM0ANxUkfXFO79KcCQelJjJkHrUoAb6VErcZNSB81JSFI2ionlpzv2qIR76Bihya3fBkDX\/i+xgAztbefoKxXjEMZY+leg\/B3SWmvbrVJEO1R5aZ9absRN2R7Ay4ix6Vkz580Vry8IazJQA+TWNjGLLcHzw4aqciGCYMOlWrflafPGHGCKllIWGQSJkUy4BAyKqW7mG4KMcA1pFQ60LUHoyuis0WDWZeQFcsowa2kWoLiLJ9qGCepnWdyZB5bHFX1UIuerVhXAa1udw4Umta3lE0anOSBSiU0SmVh16GlWVQeRSEEnpxTWH8IxVEXJTMhPWo9wJ7VWkOOKjGe1FijLM0hGA2M9hUZQ7vmyfrVpIf4jTgm89K1EQJC2cjpT3TJ461ZACjBppUA5qQIAAPlIpqxFnzjirQj39KtRQEDAXigVyKKAnlRirQj3Yz2pTmIgY4p5GV470CuQSlSNo6023hZn5HAqYW5JzV2KMIlIdxsaDgCrQUKM96ZElPl+VafQgrzHLYqREATGKiXDN71ZHC1K3KehQuB+8x2qKQHC47VYcZcmo5OBmqtcEzmvGPhyPxHoToFxcxjdE3ofSvA5YpbaZ4J1KSxsVYEdDX06G+UjvXnHxG8EtcE6xp6ZnAzNEo+8PUVUX0KWjPJuacpzQqEnB4IOKf5eOlaGg1lOOlM3Yq2gzwRUEsBzkCgBglIp6y5qLyWx0pyRNmkNInD5HWpkJI61AkRB6VciiPHFFhgIi1WY4gvWp44gFBxzTZg2QkalpG+VVXqTSBCWWmz69rEGnWqkl2G8j+Fe5NfQnh\/RIdB01bSFQMMWJHfJrnvh34OOg2BvbxQb64GW4+4PSu2dtoNTJ6WOac7uyK87c4FZ05\/eCrkhJNVLhf4vSosCLNuBtqdl75qCz5izVrGaTG2Z9\/D+6Eq8EVYspfMhB71PNGHhIxxisyxYxzNGfXip2GndGqBzimyplTTlOcU5x3qiE9TC1G386AjHzDpWdpl2VYo55BwRW\/KuWx1FcrqINjqIlHCOeajZmy1OpX51470FNq\/7VVLC88xAM5q8wLHcelXcnYoyDnJ60+CPdk4pJRl6s26nb0oEzKCccdKUjA4qQDjFOCZWtGBAFz1p6xe1TpFz0q3FCOpFCQnIit7cADIqeQLGBtqcKMYAqC4T1p2JvcY0YfnOTTUUq3NNgf8A0gLng1f8pc0rXBkKLk5NSnhafsC\/SkAJkGOlKwiSMBUyagmkzVl+EAqpIu9uKUhx7iwrzk1O33aZFyKew4pA2V9uc1XuwVhJHWrgXmmXEYaM00NlFcEgDrjNSSLkAkZXuKrqdl8g7Yq9IhJITtzSaKueY+M\/h8s0j6hpCBZfvSQDo3uPevNzatG7RyIVdTggjGK+kkIkmAYYxxisPxH4NsdaYuqCG5xkSKOvsauMu5Sm0eEeVg0\/YDxiug1nw7d6LMyXMfy54kUcEVi7oxzuUj2rQ0TRCYAe1J9nAFWRNGeisfoCauWul6lqB\/0TTrmQf3tmB+ZoDmRliIfjVqKPaK6vTfhrr966tciGzjPXe25vyrttL+Gmk2iK90ZLqQc4Y4X8qVyJVEjzLTNJv9WmEFjbtM56tjCj6mvU\/CvgO10Vlvb4rcX3UEj5U+grqbW0gs4RHbQRxJ6IuKnOOppORlKbY53AGe1QSMSuabLJlwmOtOYfJzU2ZKViEjOKhnQmM4qyRgCmSgCNsntSaGhLAhocCrfSqmnDbH071bf73tUg9x\/VDWLMDDehuxraHT2rM1GM5VqlocNy4jcA+oqQ8pVO1fzYD6irkRyMGhBJWKsi4zWFrtp59mxA+ZRnNdFKOTVK4j3xlSMg0mXFnNaJeDaAx+ZeDXVJIZI+K4LJstXZDwrHiuw0+cvGBmiOpUu5O6EPg1chTanSmqoOCal3ACqIZjRjDkNVhEpm0HA71YReQK1sTcEjq1ENq9KQJ2qTGBVWIYg9KimX5TmpR9\/ioZz8poEZ8RxdL9a2gMisWI4uUz61tL61KLY1vu4pYx0HekPWpIhkml1JbsgmO1eaqFsHFW5huFUc5kPoKllR2LSjC0tInK04UANAoZdwwaUD56cRzxQkFzHuo\/LuEf3q0CVZSejDFN1GPCBh605f3sCHuBmqHfQbGElcow\/eKeKS4ujbA7xzjg1HcMY5kmXjsao6pc7lVSfvMKTQ0yZNOj1GMi8jEqt\/C3Sprfwvo0CkLptvg\/7ANX7VAsQFXAMKD6VUSJuxTi0OyiXKWsCH0EYq3FBGAVVQMdQBQsAJdjM5DHIGen0p4+Vzg8GtZJWMrsGiUqQBURfYpB61Z61SlI3kVnYcdRDJge9IGJGTUZIPFOOFBFBZGDunzVhvu1BGuGzU7fdpDIyc1FP8ykVK2FqKTpmhjJLMYQD0qzIPlqG3HyirDjK1AnuMTlar3qb4M9xU6Hkih0BjK9c0mg2ZlWD7XIJ61qKcNWKcw3XoM1sKQyBhUI0kPkX5c1TkXGavZymKqyrQyYHE+JLcq4mUcjmruj3m+JTnqKt65biW3bjPFc5o0xjkeEnkHip2ZturHfwMWQE1I\/pVKynBhBq4egPrVmZT25fI6VPGATmmKpQVKg44rpSMrk0Ypxwc0i8LzTWyPxoYkKvFVrs4WrORjmqF2\/akMrRZa6T61uj7uKwrU\/6aordHAqVuXIb3qVOKiHWp4uVzSM5bEc52ggVRcbWBHerkh3HBqpJgd6TLjsTRt8tSVXhOBzUy8nPakOxIozTiORSJ1FOcc1SRDepFcRebCR7VTsD+7Knsa0gMoayov3d26joaY076BeoPLYYrndQJMcDDqrgH866e5G5OawLqMNuT3BFBSOmtx8ik9wKuL0xVWD\/VIfYVIWwc9qEyJK5LtB60oX8qjVsip16VV7mb0GEkVnXZaKTzAeDwRWmQKzrw\/eQjPFJlQ3I4\/wB5hhTmOTiq1q+wEZqc9d3rQWSxfeqU9Kii9akY\/LQBEeSRUbjPFSHjmm4zzUsaLEHCgVMelRRdBU3WpJluQDh6kHemOPm4pwOfrSQ2ZF\/GQ+cVaspN8GO4p2oRbkyKpWEhWQoal6M0WsTWT0pki\/Kc05eG5p8gBWmZ3szIu4g8LAjqK4KQGz1YZ6McV6LOuQRXB+I4fLn8wdQc1D2OiJ1GmygqBmtr7yCuU0SbzYkb1FdODhBTjsTNWYH5uKI8g4p3finIBu5rrRziseMUmelDkZpm7nFJgPPes24b5zWg5wpNZcrZJpFISw+bUPoK3z0rn9LP\/Ewb6VvmoRUgHUVN91ahTkmpz9ymZyK8nUmqk3TNW3PWqcxA+lQzSIituIA7VbToKpQcMSaup0FCBkqdac1NWnEg8VojN7ijhaznUJdlz3rRHKmqN0uSMcUmOO4+Ubl\/CsG8XbID71v9YQaw9SIEYP8AtUIpbm9Cp8tfpUwXsabB\/qU\/3RUop2JbGFD26VMhwMGmUvGPegh6jt3NU7tATkVYqK4GYzgUDjuZSMBOVq0xzxVMj95u71ZLfu896DQmgJJIqbsc1DbcqTUxzs460CIWHNKB8woY8e9PjGaVgJV4qXtTAKcOaklkTnDU5PWmS80qHikV0CVd6kGsM5huuT3rf7Vi6imyYNiplsVDsaincqmpvvJVeA7oF+lTx9MUImW5VmWuO8Uw\/JvrtZh1rmPEqbrI1MtDamZPhmTMIGehxXaIcoK4Tw0cCRO4au6iGYxSg7odTckH3qf2oorsRzCGmP0FFFSwGv8A6o\/Ss5+9FFHQpbjNK\/5CT\/SugNFFQimOi61K33aKKaM5blaSqV12ooqGaIRP9WKvR\/cH0oopxCRKOlKKKK0IFXvVa56miipYR3CL\/UVhap\/qv+BCiikV1Oig\/wCPdP8AdFSUUVSIYD7wp1FFAhO9Mk+5RRQNGM3+vNT\/APLMfSiigssWv3TU3rRRSEQH71TJ0oooYEop4ooqSWRSUkdFFItbEnesvVeq0UUpbDhuWrb\/AFCfSrCfeooqYhMjn6VzviD\/AI8X+lFFTMumc14c\/wCPib613dt\/qhRRU0ti6h\/\/2Q==",
//     "image": "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"
//   }
// }';
                    // print_r($responses);
                } catch (\Throwable $th) {

                    // print_r($th->getMessage());
                    echo error_res(false, "04", "Network Error! try using VNIN Search.");
                    exit;
                }

                // print_r();

                $response_std = json_decode($responses);
                // print_r($response_std);

                // return false;

                $service_record = new ServiceRecord;
                $in_transaction = new InTransaction;

                // print_r($response_std->data->image);

                // return false;

                if ($response_std->success == true) {
                    $status = 1;

                    $new_response_std = new stdClass;
                    $new_response_std->response_code = "00";
                    $new_response_std->detail = "Verification Successful";
                    $new_response_std->nin_data = new stdClass;

                    $new_response_std->nin_data->birthdate = $response_std->response[0]->birthdate;
                    $new_response_std->nin_data->birthlga = $response_std->response[0]->birthlga;
                    $new_response_std->nin_data->birthstate = $response_std->response[0]->birthstate;
                    $new_response_std->nin_data->centralID = $response_std->response[0]->centralID ?? '';
                    $new_response_std->nin_data->educationallevel = $response_std->response[0]->educationallevel ?? '';
                    $new_response_std->nin_data->email = $response_std->response[0]->email ?? '';
                    $new_response_std->nin_data->emplymentstatus = $response_std->response[0]->emplymentstatus ?? '';
                    $new_response_std->nin_data->firstname = $response_std->data->firstname;
                    $new_response_std->nin_data->middlename = $response_std->data->middlename ?? '';
                    $new_response_std->nin_data->gender = strtoupper($response_std->data->gender);
                    $new_response_std->nin_data->heigth = $response_std->response[0]->heigth ?? '';
                    $new_response_std->nin_data->maritalstatus = $response_std->response[0]->maritalstatus ?? '';
                    $new_response_std->nin_data->nin = $response_std->data->nin;
                    $new_response_std->nin_data->trackingId = $response_std->data->trackingid ?? '';
                    $new_response_std->nin_data->nok_address1 = $response_std->response[0]->nok_address1 ?? '';
                    $new_response_std->nin_data->nok_address2 = $response_std->response[0]->nok_address2 ?? '';
                    $new_response_std->nin_data->nok_firstname = $response_std->response[0]->nok_firstname ?? '';
                    $new_response_std->nin_data->nok_lga = $response_std->response[0]->nok_lga ?? '';
                    $new_response_std->nin_data->nok_middlename = $response_std->response[0]->nok_middlename ?? '';
                    $new_response_std->nin_data->nok_postalcode = $response_std->response[0]->nok_postalcode ?? '';
                    $new_response_std->nin_data->nok_state = $response_std->response[0]->nok_state ?? '';
                    $new_response_std->nin_data->nok_surname = $response_std->response[0]->nok_surname ?? '';
                    $new_response_std->nin_data->nok_town = $response_std->response[0]->nok_town ?? '';
                    $new_response_std->nin_data->nspokenlang = $response_std->response[0]->nspokenlang ?? '';
                    $new_response_std->nin_data->ospokenlang = $response_std->response[0]->ospokenlang ?? '';
                    $new_response_std->nin_data->pfirstname = $response_std->response[0]->pfirstname ?? '';
                    $new_response_std->nin_data->photo = $response_std->data->image ?? '';
                    $new_response_std->nin_data->signature = $response_std->response[0]->signature ?? '';
                    $new_response_std->nin_data->pmiddlename = $response_std->response[0]->pmiddlename ?? '';
                    $new_response_std->nin_data->profession = $response_std->response[0]->profession ?? '';
                    $new_response_std->nin_data->psurname = $response_std->response[0]->psurname ?? '';
                    $new_response_std->nin_data->religion = $response_std->response[0]->religion ?? '';
                    $new_response_std->nin_data->residence_address  = $response_std->data->address ?? '';
                    $new_response_std->nin_data->residence_town = $response_std->data->town ?? '';
                    $new_response_std->nin_data->residence_lga = $response_std->response[0]->residence_lga ?? '';
                    $new_response_std->nin_data->residence_state = $response_std->data->state ?? '';
                    $new_response_std->nin_data->residencestatus = $response_std->response[0]->residencestatus ?? '';
                    $new_response_std->nin_data->self_origin_lga = $response_std->response[0]->self_origin_lga ?? '';
                    $new_response_std->nin_data->self_origin_place = $response_std->response[0]->self_origin_place ?? '';
                    $new_response_std->nin_data->self_origin_state = $response_std->response[0]->self_origin_state ?? '';
                    $new_response_std->nin_data->surname = $response_std->data->lastname;
                    $new_response_std->nin_data->telephoneno = $response_std->response[0]->telephoneno;
                    $new_response_std->nin_data->title = $response_std->response[0]->title ?? '';
                    $new_response_std->nin_data->vnin = $response_std->response[0]->vnin ?? '';
                    $new_response_std->nin_data->userid = $response_std->response[0]->userid ?? '';

                    $new_response_std->verification = new stdClass;
                    $new_response_std->verification->status = $response_std->verificationStatus;
                    $new_response_std->verification->reference = $response_std->transactionReference;

                    $new_wallet_balance = $my_wallet_balance - $service_fee;
                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                    
                } else if ($response_std->success == false) {
                    echo error_res(false, "01", $response_std->message);
                    $new_wallet_balance = $my_wallet_balance  - 50;
                    $my_wallet->balance = $new_wallet_balance;
                    $my_wallet->date_updated = $date;
                    $my_wallet->save();
                    
                    $in_transaction->user_id = $user->id;
                    $in_transaction->wallet_id = $my_wallet->id;
                    $in_transaction->search_query = $nin;
                    $in_transaction->amount = 50;
                    $in_transaction->remaining_balance = $new_wallet_balance;
                    $in_transaction->service = $service_type->service_name;
                    $in_transaction->status = $status;
                    $in_transaction->date = $date;
                    $in_transaction->save();
                    exit;
                } else {
                    $new_wallet_balance = $my_wallet->balance;
                    $service_fee = 0;
                }

                
                $in_transaction->user_id = $user->id;
                $in_transaction->wallet_id = $my_wallet->id;
                $in_transaction->search_query = $nin;
                $in_transaction->amount = $service_fee;
                $in_transaction->remaining_balance = $new_wallet_balance;
                $in_transaction->service = $service_type->service_name;
                $in_transaction->status = $status;
                $in_transaction->date = $date;
                $in_transaction->save();

                $service_record->user_id = $user->id;
                $service_record->in_transaction_id = $in_transaction->id;
                $service_record->service = $service_type->service_name;
                $service_record->search_query = $nin;
                $service_record->response = json_encode($new_response_std);
                $service_record->save();
                
                $new_response_std->record_id = $service_record->id;

                echo json_encode($new_response_std);
            } else {
                echo error_res(false, "02", "Insufficient balance, please fund your wallet!");
                exit;
            }
        } else {
            echo error_res(false, "02", "User not found!");
            exit;
        }
    } else {
        echo error_res(false, "02", "Service type is not selected or NIN is empty");
        exit;
    }
} else {
    echo error_res(false, "02", "You must login first");
    exit;
}
?>
