<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once('../../vendor/autoload.php');
require_once('../init.php');

function error_res($status, $response_code, $message)
{
    $response = new stdClass;
    $response->status = $status;
    $response->response_code = $response_code;
    $response->message = $message;
    return json_encode($response);
}

if (isset($_SESSION['user_id'])) {
    extract($_POST); 
    $user = User::find_by_id($_SESSION['user_id']);
    
    if ($user) {
        $validation_service = validation::find_by_id($id); 

        if ($validation_service) {

            if (!empty($tracking_id)) {
                $validation_service->new_tracking_id = $tracking_id; 
            } 
            
            $validation_service->comment = $the_comment;

            if ($validation_service->save()) {
                echo error_res(true, "00", "Tracking ID and Comment updated successfully.");
                exit;
            } else {
                echo error_res(false, "03", "Failed to update Tracking ID and Comment.");
                exit;
            }
        } else {
            echo error_res(false, "03", "Validation service not found.");
            exit;
        }
    } else {
        echo error_res(false, "03", "User not found.");
        exit;
    }
} else {
    echo error_res(false, "03", "Unauthorized access.");
    exit;
}
