<?php

ini_set('memory_limit', -1);
require_once("../main_includes/init.php");
if (!isset($_GET['record'], $_SESSION['user_id'])) {
    redirect("../");
}
require('fpdf/fpdf.php');
// include('../includes/configpdo.php');

$user = User::find_by_id($_SESSION['user_id']);
if (!$user) {
    redirect("../");
}

$sub_service = SubService::find_by_id($_GET['service_id']);
if (!$sub_service) {
    redirect("../");
}

$service_fee = intval($sub_service->service_fee);
$status = 1;
$service = $sub_service->service_name;

$my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
$my_wallet = array_shift($my_wallet);
$my_wallet_balance = intval($my_wallet->balance);



$service_record = ServiceRecord::find_by_id($_GET['record']);
if (!$service_record) {
    redirect("../");
    return false;
}

$response_std = json_decode($service_record->response);
// echo "<pre>";
// print_r($response_std);
$bvn = $response_std->data->bvn;
$nin = $response_std->data->nin;

$names = $response_std->data->firstName . ($response_std->data->middleName == "****" || $response_std->data->middleName == "" ? "" : " " . $response_std->data->middleName) . " " . $response_std->data->surName;


$in_transaction = new InTransaction;
$in_transaction->user_id = $user->id;
$in_transaction->wallet_id = $my_wallet->id;
$in_transaction->amount = $service_fee;
$in_transaction->remaining_balance = $my_wallet_balance;
$in_transaction->service = $service;
$in_transaction->date = $status == 1 ? $date : $in_transaction->date;
$in_transaction->service_id = intval($sub_service->service_id);
$in_transaction->status = $status;
$in_transaction->record_id = $service_record->id;
$in_transaction->search_query = $service_record->search_query;
if (!isset($_GET['redownload'])) {
$in_transaction->save();
}

$sub1 = substr($bvn, 0, 4);
$sub2 = substr($bvn, 4, 3);
$sub3 = substr($bvn, 7, 4);


class PDF extends FPDF
{

    function Header()
    {
        // Select Arial bold 15
        $this->AddFont('OCR-B 10 BT', '', 'OCR-B 10 BT.php');
        $this->SetFont('OCR-B 10 BT', '', 18);
        $this->SetTextColor(0, 0, 0);
        $this->SetDrawColor(0, 0, 155);
        $this->Ln(1);
        $this->SetFont('Arial', 'B', 11);
        $this->Cell(0, 5, 'Please find below your new High Resolution BVN Slip.', 0, 1, 'C');
        $this->Cell(0, 5, 'You may cut it out of the paper, fold and laminate as desired.', 0, 1, 'C');
        $this->Cell(0, 5, 'Please DO NOT allow others to make copies of your BVN Slip.', 0, 1, 'C');

        $this->Image('bvn_premium_1.png', 60, 55, 87, 52);

$this->Image('bvn_back.png', 60.6, 110, 87.5, 53);

        $this->Ln(2); 
    }

    function TextWithRotation($x, $y, $txt, $txt_angle, $font_angle = 0)
    {
        $font_angle += 90 + $txt_angle;
        $txt_angle *= M_PI / 180;
        $font_angle *= M_PI / 180;

        $txt_dx = cos($txt_angle);
        $txt_dy = sin($txt_angle);
        $font_dx = cos($font_angle);
        $font_dy = sin($font_angle);

        $s = sprintf('BT %.2F %.2F %.2F %.2F %.2F %.2F Tm (%s) Tj ET', $txt_dx, $txt_dy, $font_dx, $font_dy, $x * $this->k, ($this->h - $y) * $this->k, $this->_escape($txt));
        if ($this->ColorFlag)
            $s = 'q ' . $this->TextColor . ' ' . $s . ' Q';
        $this->_out($s);
    }

    function Footer()
    {

    }
} 


 

$filename = './tmp/t' . rand(00000000, 99999999) . '.jpeg';
if (file_exists($filename)) {
    unlink($filename);
}
$img_o = base64_decode($response_std->data->base64Image);
$img =  imagecreatefromstring($img_o);
imagejpeg($img, $filename);

$date_string = strtotime($response_std->data->dateOfBirth);
$birthdate = date("d M Y", $date_string);

$reg_date = date("d M Y");

$gender =  $response_std->data->gender == 'Male' ? 'M' : 'F';

$pdf = new PDF();
// $pdf->AddFont('BookAntiqua', '', 'bookantiqua.php');
 
 
$pdf->AliasNbPages();
$pdf->AddPage('P', 'A4');
$pdf->SetFont('', '', 11);
$pdf->SetFillColor(255, 255, 255);
  
$pdf->Image($filename, 63.5, 71, 18);

$pdf->Image('thump-bvn.png', 63.5, 91, 10);

$pdf->SetDrawColor(150, 150, 150);
$pdf->SetFont('', 'B', 10);

$pdf->SetFont('', '', 10);

$pdf->SetTextColor(0, 0, 0);

// $pdf->Cell(75, 2, '', 0, 0, 'L', false);
// $pdf->SetFont('', '', 10);
// $pdf->Cell(0, 6, '', 0, 1, 'L', false);

// $pdf->Cell(79, 0, '', 0, 0, 'L', false);
$pdf->SetFont('', 'B', 7);

$pdf->SetX(86.4);
$pdf->SetFont('', 'B', 7);
$pdf->Cell(0, 95, $response_std->data->lastName != "****" ? $response_std->data->lastName : '', 0, 1, 'L', false);

$pdf->SetX(86.4);
$pdf->Cell(10, -78, $response_std->data->firstName . ($response_std->data->middleName == "****" || $response_std->data->middleName == '' ? '' : ", " . $response_std->data->middleName), 0, 1, 'L', false);

$pdf->SetX(86.4);
$pdf->SetFont('', 'B', 8);
$pdf->Cell(0, 95, $birthdate, 0, 1, 'L', false);

$pdf->SetX(110);
$pdf->SetFont('', 'B', 8);
$pdf->Cell(10, -95.8, $gender, 0, 1, 'L', false);

$pdf->SetX(125);
$pdf->SetFont('', 'B', 8);
$pdf->Cell(0, 96, $reg_date, 0, 1, 'L', false);

$pdf->SetX(80);
$pdf->SetFont('OCR-B 10 BT', '', 18);
$pdf->SetTextColor(10, 40, 112);
$pdf->Cell(0, -76.8, $sub1 . " " . $sub2 . " " . $sub3, 0, 1, 'L', false);


// if ($response_std->data->photo != '') {
    if (file_exists($filename)) {
        unlink($filename);
    }
// }

$doc_name = $bvn . "_bvn_premium_slip.pdf";

$pdf->Output("I", $doc_name);