<?php include "main_includes/header.php" ?>

<body  style="background-image: url(assets/img/confirmid_bg.jpg); background-repeat: no-repeat;background-size: cover; background-position: center; background-attachment: fixed;" class="h-screen">


    <section class="">

    <div class="flex flex-col items-center justify-center px-6 py-8 mx-auto lg:py-0">
        <a href="#" class="flex items-center mb-6 text-2xl font-semibold text-gray-900 dark:text-white">
        <div class="rounded w-20 h-20">
                <img src="./assets/img/favicon.png" alt="" srcset="">
            </div>
        </a>
        <div
            class="w-full bg-emerald-800 rounded-lg shadow dark:border md:mt-0 sm:max-w-md xl:p-0 dark:bg-emerald-800 dark:border-emerald-700">
            <div class="p-6 space-y-2 sm:p-8">
                <h1 class="text-xl font-bold leading-tight tracking-tight text-gray-900 md:text-2xl dark:text-white">
                    Create and account
                </h1>
                <form id="registration_form" method="post" class="space-y-4 md:space-y-6">
                    <div>
                        <label for="first_name" class="block text-sm font-medium text-gray-900 dark:text-white">Your
                            First name</label>
                        <input type="text" name="first_name" id="first_name"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500"
                            placeholder="e.g Bouer">

                    </div>
                    <div>
                        <label for="last_name" class="block text-sm font-medium text-gray-900 dark:text-white">Your Last
                            name</label>
                        <input type="text" name="last_name" id="last_name"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500"
                            placeholder="e.g Micheal">

                    </div>
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-900 dark:text-white">Your
                            email</label>
                        <input type="email" name="email" id="email"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500"
                            placeholder="e.g your@email.com">

                    </div>
                    <div>
                        <label for="phone" class="block text-sm font-medium text-gray-900 dark:text-white">Your phone
                            number</label>
                        <input type="number" name="phone" id="phone"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500"
                            placeholder="e.g 08000000000">

                    </div>
                    <!--<div>-->
                    <!--    <label for="phone" class="block text-sm font-medium text-gray-900 dark:text-white">Your BVN-->
                    <!--        number</label>-->
                    <!--    <input type="number" name="bvn" id="bvn"-->
                    <!--        class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500"-->
                    <!--        placeholder="e.g 222....">-->

                    <!--</div>-->
                    <div>
                        <label for="business_name" class="block text-sm font-medium text-gray-900 dark:text-white">Your
                            Business name</label>
                        <input name="business_name" id="business_name"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500">

                    </div>
                    <div>
                        <label for="address" class="block text-sm font-medium text-gray-900 dark:text-white">Your
                            Address</label>
                        <input name="address" id="address"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500">

                    </div>
                    <div>
                        <label for="password"
                            class="block text-sm font-medium text-gray-900 dark:text-white">Password</label>
                        <input type="password" name="password" id="password" placeholder="••••••••"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500">

                    </div>
                    <div>
                        <label for="confirm_pass"
                            class="block text-sm font-medium text-gray-900 dark:text-white">Confirm password</label>
                        <input type="password" name="confirm_pass" id="confirm_pass" placeholder="••••••••"
                            class="bg-gray-50 py-2 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-white dark:border-gray-600 dark:placeholder-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500">

                    </div>
                    <div class="flex items-start">
                        <div class="flex items-center h-5">
                            <input id="terms" required aria-describedby="terms" type="checkbox"
                                class="w-4 h-4 border border-gray-300 rounded bg-gray-50 focus:ring-3 focus:ring-primary-300 dark:bg-white dark:border-gray-600 dark:focus:ring-primary-600 dark:ring-offset-gray-800">
                        </div>
                        <div class="ml-3 text-sm">
                            <label for="terms" class="font-light text-gray-500 dark:text-gray-300">I accept the <a
                                    class="font-medium text-primary-600 hover:underline dark:text-primary-500"
                                    data-modal-target="defaultModal" data-modal-toggle="defaultModal" href="#">Terms and
                                    Conditions</a></label>
                        </div>
                    </div>

                    <button type="submit" name="register" id="register"
                        class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium bg-slate-900 hover:bg-slate-950 rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800 ">Create
                        an account</button>
                    <p class="text-sm font-light text-gray-500 dark:text-gray-400">
                        Already have an account? <a href="sign-in"
                            class="font-bold hover:underline text-white">Login here</a>
                    </p>
                </form>
            </div>
        </div>
    </div>
    </section>
</body>



<!-- Main modal -->
<div id="defaultModal" tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full backdrop-blur">
    <div class="relative w-full max-w-2xl max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-white">
            <!-- Modal header -->
            <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900">
                    Terms of Service
                </h3>
                <button type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white"
                    data-modal-hide="defaultModal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    Please read these Terms and Conditions ("Terms") carefully before using the confirmid.com.ng
                    website (the "Service") operated by Always Verify Ltd. ("us," "we," or "our").
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    By accessing or using the Service, you agree to be bound by these Terms. If you do not agree to all
                    the terms and conditions of this agreement, please do not use the Service.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    1. Registration and User Accounts
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    1.1. You must be at least 18 years old to use our Service.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    1.2. You agree to provide accurate, current, and complete information during the registration
                    process and to update such information to keep it accurate, current, and complete.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    1.3. You are responsible for maintaining the confidentiality of your account and password and for
                    restricting access to your account. You agree to accept responsibility for all activities that occur
                    under your account.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    2. Identity Verification
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    2.1. Our Service provides identity verification services for authorized individuals and
                    organizations. We do not guarantee the accuracy or completeness of the information provided.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    2.2. You agree to use our Service only for lawful purposes and in compliance with all applicable
                    laws and regulations.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    3. Privacy
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    3.1. Our Privacy Policy explains how we collect, use, and protect your personal information. By
                    using our Service, you consent to our collection and use of your information as described in the
                    Privacy Policy.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    4. Fees and Payment
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    4.1. We may charge fees for certain features or services. You agree to pay all applicable fees in
                    accordance with our pricing terms.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    5. Intellectual Property
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    5.1. All content on the Service, including text, graphics, logos, images, and software, is the
                    property of Always Verify Ltd. and is protected by copyright and other intellectual property laws.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    6. Termination
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    6.1. We reserve the right to terminate or suspend your account and access to the Service at our
                    discretion, without notice, for any violation of these Terms or for any other reason.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    7. Disclaimer
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    7.1. The Service is provided "as is" without warranties of any kind, either express or implied,
                    including, but not limited to, the implied warranties of merchantability, fitness for a particular
                    purpose, or non-infringement.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    8. Limitation of Liability
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    8.1. To the fullest extent permitted by applicable law, Always Verify Ltd. shall not be liable for
                    any indirect, incidental, special, consequential, or punitive damages, or any loss of profits or
                    revenues.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    9. Governing Law
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    9.1. These Terms shall be governed by and construed in accordance with the laws of Nigeria.
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    10. Contact Information
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    10.1. If you have any questions or concerns about these Terms, please contact us at
                    info@confirmid.com.ng </p>
                </p>
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    The European Union’s General Data Protection Regulation (G.D.P.R.) goes into effect on May 25 and is
                    meant to ensure a common set of data rights in the European Union. It requires organizations to
                    notify users as soon as possible of high-risk data breaches that could personally affect them.
                </p>
            </div>
            <!-- Modal footer -->
            <div class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                <button data-modal-hide="defaultModal" type="button"
                    class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg text-sm px-5 py-2 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">I
                    accept</button>
                <button data-modal-hide="defaultModal" type="button"
                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2 hover:text-gray-900 focus:z-10 dark:bg-white dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600">Decline</button>
            </div>
        </div>
    </div>
</div>




<?php
include "./main_includes/loader_out.php";
?>
<!-- plugin for scrollbar  -->
<!-- <script src="./assets/js/plugins/perfect-scrollbar.min.js" async></script> -->
<!-- main script file  -->
<!-- <script src="./assets/js/soft-ui-dashboard-tailwind.js?v=1.0.4" async></script> -->
<script src="./assets/iziToast-master/dist/js/iziToast.js"></script>

<script>
    $(document).ready(function () {
        // $('.lds-ellipsis').fadeOut('slow')
        $('#register').prop('disabled', false)
    })
    $(document).on("submit", "#registration_form", function (e) {
        e.preventDefault()
        // $('.lds-ellipsis').fadeIn('slow')
        $('#register').prop('disabled', true)

        var phone = $("#phone").val()
        // var bvn = $("#bvn").val()
        var email = $("#email").val()
        var first_name = $("#first_name").val()
        var last_name = $("#last_name").val()
        var business_name = $("#business_name").val()
        var password = $("#password").val()
        var confirm_pass = $("#confirm_pass").val()

        if (phone.length != 11) {

            // $('.lds-ellipsis').fadeOut('slow')
            $('#register').prop('disabled', false)
            iziToast.show({
                title: 'Error',
                message: 'Invalid Phone Number Length',
                color: "red",
                position: "topRight",
                balloon: true
            });
            return false
        }
        
        //  if (bvn.length != 11) {

        //     // $('.lds-ellipsis').fadeOut('slow')
        //     $('#register').prop('disabled', false)
        //     iziToast.show({
        //         title: 'Error',
        //         message: 'Invalid Phone Number Length',
        //         color: "red",
        //         position: "topRight",
        //         balloon: true
        //     });
        //     return false
        // }
        if (first_name == "") {

            // $('.lds-ellipsis').fadeOut('slow')
            iziToast.show({
                title: 'Error',
                message: 'First Name Field Cannot be Empty',
                color: "red",
                position: "topRight",
                balloon: true
            });
            $('#register').prop('disabled', false)
            return false
        }
        if (last_name == "") {

            // $('.lds-ellipsis').fadeOut('slow')
            iziToast.show({
                title: 'Error',
                message: 'Last Name Field Cannot be Empty',
                color: "red",
                position: "topRight",
                balloon: true
            });
            $('#register').prop('disabled', false)
            return false
        }
        if (business_name == "") {

            // $('.lds-ellipsis').fadeOut('slow')
            iziToast.show({
                title: 'Error',
                message: 'Business Name Field Cannot be Empty',
                color: "red",
                position: "topRight",
                balloon: true
            });
            $('#register').prop('disabled', false)
            return false
        }
        if (email == "") {

            // $('.lds-ellipsis').fadeOut('slow')
            iziToast.show({
                title: 'Error',
                message: 'Email Field Cannot be Empty',
                color: "red",
                position: "topRight",
                balloon: true
            });
            $('#register').prop('disabled', false)
            return false
        }
        if (address == "") {

            iziToast.show({
                title: 'Error',
                message: 'Address Field Cannot be Empty',
                color: "red",
                position: "topRight",
                balloon: true
            });
            // $('.lds-ellipsis').fadeOut('slow')

            $('#register').prop('disabled', false)
            return false
        }
        if (password.length < 6) {

            iziToast.show({
                title: 'Error',
                message: 'Password length must be at least 6 characters',
                color: "red",
                position: "topRight",
                balloon: true
            });
            // $('.lds-ellipsis').fadeOut('slow')
            $('#register').prop('disabled', false)
            return false
        }
        if (confirm_pass != password) {

            iziToast.show({
                title: 'Error',
                message: 'Password do not match',
                color: "red",
                position: "topRight",
                balloon: true
            });
            // $('.lds-ellipsis').fadeOut('slow')
            $('#register').prop('disabled', false)
            return false
        }


        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "main_includes/components/create_user.php",
            data: $(this).serialize(),
            success: function (response) {
                // console.log(response)
                $('#register').prop('disabled', false)
                if (response.response_code == "00") {

                    // iziToast.show({
                    //     title: 'Done',
                    //     message: 'Registration Successfuly.',
                    //     color: "green",
                    //     position: "topRight",
                    //     balloon: true,
                    //     onClosing: function() {
                    //         document.location.href = "sign-in"

                    //     }
                    // });
                    iziToast.show({
                        title: 'User Registered Successfuly',
                        message: 'Login using Email and Password.',
                        color: "green",
                        position: "topRight",
                        balloon: true,
                        onClosing: function () {
                            document.location.href = "sign-in"

                        }
                    });


                } else {

                    iziToast.show({
                        title: 'Error',
                        message: response.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });
                }
            },
            error: function (error) {
                // $('.lds-ellipsis').fadeOut('slow')
                $('#register').prop('disabled', false)
                // console.log(error)
                if (error) {
                    var res = JSON.parse(error.responseText)


                    iziToast.show({
                        title: 'Error',
                        message: res.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });

                }
            }
        })



    })
</script>

</html>