<div class="p-2 sm:ml-64 mb-14">
    <nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-gray-700 border border-gray-200 rounded-lg bg-gray-50 dark:bg-teal-800 dark:border-gray-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="#"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">NIN
                        Verifications</a>
                </div>
            </li>

        </ol>
    </nav>
    <div class="p-2 rounded-lg dark:border-gray-700">


        <h3 class="text-gray-400 text-sm">Verification Services</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 items-center justify-center rounded py-4 ">
            <a href="<?= BASE_URL ?>/verifications/-nin_verifications"
                class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                <div class="flex">
                    <div class="w-2/4 flex">

                        <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: #0f5132;transform: ;msFilter:;">
                                <path
                                    d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                </path>
                            </svg>
                        </div>
                        <span class="font-bold">NIN Verifications</span>

                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their National Identity Number.</span>
                </div>
                <div class="flex justify-between">
                    <div class="text-right">
                        <span class="text-sm bg-teal-800 text-white rounded py-1 px-2 hover:scale-105">Use Service</span>

                    </div>

                </div>

            </a>
            <?php $services = Service::find_by_query("SELECT * FROM service WHERE category='BVN'");
            // print_r($services);
            foreach ($services as $service):
                if ($user->role == 1 || ($service->display == 1)):
                    ?>
                    <a href="<?= BASE_URL ?>/varifications/-verification_page/<?= $service->id ?>"
                        class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                        <div class="flex">
                            <div class="w-2/4 flex">

                                <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                        style="fill: #0f5132;transform: ;msFilter:;">
                                        <path
                                            d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                        </path>
                                    </svg>
                                </div>
                                <span class="font-bold">
                                    <?= $service->service_name ?>
                                </span>

                            </div>
                            <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                                <div class="text-right">
                                    <?php if ($service->status == 1): ?>
                                        <span
                                            class=" bg-[#d1e7dd] border border-[#badbcc] px-2 rounded text-[#0f5132] text-xs py-1 whitespace-nowrap">
                                            Service Available
                                        </span>
                                    <?php else: ?>

                                        <span
                                            class=" bg-[#f8d7da] border border-[#f5c2c7] px-2 rounded text-[#842029] text-xs py-1 whitespace-nowrap">
                                            Service Shutdown
                                        </span>
                                    <?php endif; ?>

                                </div>
                            </div>

                        </div>

                        <div class="flex flex-col my-3">
                            <span class="text-xs">
                                <?= $service->description ?>
                            </span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm bg-teal-800 text-white rounded py-1 px-2 hover:scale-105 whitespace-nowrap">Use
                                Service</span>
                            <div class="text-right">
                                <span
                                    class=" bg-[#d1e7dd] border border-[#badbcc] px-2 rounded text-[#0f5132] text-xs py-1 whitespace-nowrap">
                                    ₦
                                    <?= $service->service_fee ?>
                                </span>
                            </div>

                        </div>

                    </a>

                <?php endif; endforeach; ?>
             <a href="<?= BASE_URL ?>/verifications/-jamb_services"
                    class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                <div class="flex">
                    <div class="w-2/4 flex">

                        <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: #0f5132;transform: ;msFilter:;">
                                <path
                                    d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                </path>
                            </svg>
                        </div>
                        <span class="font-bold">JAMB Services</span>

                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                <div class="flex flex-col my-3">
                    <span class="text-xs">JAMB Services</span>
                </div>
                <div class="flex justify-between">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>

            </a>
            <a href="<?= BASE_URL ?>/varifications/-verification_page/17"
                class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                <div class="flex">
                    <div class="w-2/4 flex">

                        <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: #0f5132;transform: ;msFilter:;">
                                <path
                                    d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                </path>
                            </svg>
                        </div>
                        <span class="font-bold">Voter's Card Verifications</span>

                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their Voter's card Number.</span>
                </div>
                <div class="flex justify-between">
                    <div class="text-right">
                        <span class="text-sm bg-teal-800 text-white rounded py-1 px-2 hover:scale-105">Use Service</span>

                    </div>

                </div>

            </a>
            
            <a href="<?= BASE_URL ?>/verifications/-validation_services" 
                class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                <div class="flex">
                    <div class="w-2/4 flex">

                        <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: #0f5132;transform: ;msFilter:;">
                                <path
                                    d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                </path>
                            </svg>
                        </div>
                        <span class="font-bold">NIN validation & IPE clearing</span>

                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                <div class="flex flex-col my-3">
                    <span class="text-xs">NIN validation & IPE clearing</span>
                </div>
                <div class="flex justify-between">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>

            </a>
            
            <a href="<?= BASE_URL ?>/varifications/-verification_page/17"
                class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                <div class="flex">
                    <div class="w-2/4 flex">

                        <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: #0f5132;transform: ;msFilter:;">
                                <path
                                    d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                </path>
                            </svg>
                        </div>
                        <span class="font-bold">Bank Account Verifications</span>

                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                <div class="flex flex-col my-3">
                    <span class="text-xs">Verify people using their Bank Account Number.</span>
                </div>
                <div class="flex justify-between">
                    <div class="text-right">
                        <span
                            class="text-sm bg-teal-800 text-white rounded py-1 px-2 hover:scale-105">Use Service</span>

                    </div>

                </div>

            </a>
            
             <a href="<?= BASE_URL ?>/verifications/-bvn_phone_page/21" 
                class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                <div class="flex">
                    <div class="w-2/4 flex">

                        <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: #0f5132;transform: ;msFilter:;">
                                <path
                                    d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                </path>
                            </svg>
                        </div>
                        <span class="font-bold">BVN Search with Phone Number</span>

                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                <div class="flex flex-col my-3">
                    <span class="text-xs">BVN Search with Phone Number</span>
                </div>
                <div class="flex justify-between">
                    <div class="text-right">
                        <span class="text-sm bg-cyan-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>

            </a>
            <a href="<?= BASE_URL ?>/varifications/-verification_page/17"
                class="flex flex-col h-auto mb-2 p-4 text-teal-800 bg-emerald-200 transition-all shadow-emerald-900 shadow-md rounded w-full hover:text-emerald-600">
                <div class="flex">
                    <div class="w-2/4 flex">

                        <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                style="fill: #0f5132;transform: ;msFilter:;">
                                <path
                                    d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                </path>
                            </svg>
                        </div>
                        <span class="font-bold">TIN Verifications</span>

                    </div>
                    <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                        <div class="text-right">

                        </div>
                    </div>

                </div>

                <div class="flex flex-col my-3">
                    <span class="text-xs">Verify Tax Identification Number (TIN Number).</span>
                </div>
                <div class="flex justify-between">
                    <div class="text-right">
                        <span class="text-sm bg-teal-800 text-white rounded py-1 px-2 hover:scale-105">Use
                            Service</span>

                    </div>

                </div>

            </a>


        </div>

    </div>
</div>