<?php


ini_set('memory_limit', -1);
require_once("../main_includes/init.php");
require_once("phpqrcode/qrlib.php");

require('fpdf/fpdf.php');
// include('../includes/configpdo.php');
if (!isset($_GET['record'], $_SESSION['user_id'], $_GET['service_id'])) {
    redirect("../");
}

$user = User::find_by_id($_SESSION['user_id']);
if (!$user) {
    redirect("../");
}

$sub_service = SubService::find_by_id($_GET['service_id']);
if (!$sub_service) {
    redirect("../");
}

$service_fee = intval($sub_service->service_fee);
$status = 1;
$service = $sub_service->service_name;

$my_wallet = Wallet::find_by_query("SELECT * FROM wallet WHERE user_id =" . $user->id . " LIMIT 1");
$my_wallet = array_shift($my_wallet);
$my_wallet_balance = intval($my_wallet->balance);

// if ($my_wallet_balance < $service_fee) {
//     redirect("../");
//     return false;
// }

$service_record = ServiceRecord::find_by_id($_GET['record']);
if (!$service_record) {

    redirect("../");
    return false;
}

$in_transaction = new InTransaction;

// $new_wallet_balance = $my_wallet_balance  - $service_fee;
// $my_wallet->balance = $new_wallet_balance;
// $my_wallet->date_updated = $date;
// $my_wallet->save();

$in_transaction->user_id = $user->id;
$in_transaction->wallet_id = $my_wallet->id;
$in_transaction->amount = $service_fee;
$in_transaction->remaining_balance = $my_wallet_balance;
$in_transaction->service_id = $sub_service->service_id;
$in_transaction->service = $service;
$in_transaction->date = $status == 1 ? $date : $in_transaction->date;
$in_transaction->status = $status;
$in_transaction->record_id = $service_record->id;
$in_transaction->search_query = $service_record->search_query;

if (!isset($_GET['redownload'])) {
$in_transaction->save();
}
$response_std = json_decode($service_record->response);

// $nin = $response_std->nin_data->nin;
$nin = $response_std->nin_data->nin != '' ? $response_std->nin_data->nin : $service_record->search_query;


$date_string = strtotime($response_std->nin_data->birthdate);
$birthdate = date("d M Y", $date_string);
$issue_date_string = strtotime($date);
$issue_date = date("d M Y", $issue_date_string);


$qr_file = "qr_temp/test.png";

$names = $response_std->nin_data->firstname . ($response_std->nin_data->middlename == "****" || $response_std->nin_data->middlename == "" ? "" : " " . $response_std->nin_data->middlename) . " " . $response_std->nin_data->surname;

QRcode::png('{"NIN":"' . $nin . '", "Names": "' . $names . '", "Date of Birth":"' . $birthdate . '", "Status":"Verified"}', $qr_file, QR_ECLEVEL_M, 3, 0);
// QRcode::png('{"l": "n", "h":"e696da32e11c1cd69d7224f8d15637fd1de1faa8", "sig":"mjyhuogy7y08luiy98yuhoih98"}', $qr_file, QR_ECLEVEL_M);

// QRcode::png('{"l": "n", "h":"e696da32e11c1cd69d7224f8d15637fd1de1faa8", "sig":"mjyhuogy7y08luiy98yuhoih98"}', $qr_file, QR_ECLEVEL_M, 3, 0);

$sub1 = substr($nin, 0, 4);
$sub2 = substr($nin, 4, 3);
$sub3 = substr($nin, 7, 4);

class PDF extends FPDF
{

    function Header()
    {
        // Select Arial bold 15
        $this->AddFont('OCR-B 10 BT', '', 'OCR-B 10 BT.php');
        $this->SetFont('OCR-B 10 BT', '', 18);
        $this->SetTextColor(0, 0, 0);
        $this->SetDrawColor(0, 0, 155);
        $this->Ln(1);
        $this->SetFont('Arial', 'B', 11);
        $this->Cell(0, 5, 'Please find below your new High Resolution NIN Slip.', 0, 1, 'C');
        $this->Cell(0, 5, 'You may cut it out of the paper, fold and laminate as desired.', 0, 1, 'C');
        $this->Cell(0, 5, 'Please DO NOT allow others to make copies of your NIN Slip.', 0, 1, 'C');

        $this->Image('premium_nin_bg.jpg', 66, 51, 90, 109);
        // $this->Image('premium_nin_bg.jpg', 60, 51, 90, 99);
        // $this->Image('premium_nin_bg.jpg', 66, 51, 80);
        // Line break 
        $this->Ln(2);
    }

    function TextWithRotation($x, $y, $txt, $txt_angle, $font_angle = 0)
    {
        $font_angle += 90 + $txt_angle;
        $txt_angle *= M_PI / 180;
        $font_angle *= M_PI / 180;

        $txt_dx = cos($txt_angle);
        $txt_dy = sin($txt_angle);
        $font_dx = cos($font_angle);
        $font_dy = sin($font_angle);

        $s = sprintf('BT %.2F %.2F %.2F %.2F %.2F %.2F Tm (%s) Tj ET', $txt_dx, $txt_dy, $font_dx, $font_dy, $x * $this->k, ($this->h - $y) * $this->k, $this->_escape($txt));
        if ($this->ColorFlag)
            $s = 'q ' . $this->TextColor . ' ' . $s . ' Q';
        $this->_out($s);
    }

    function Footer()
    {
        // Go to 0.9 cm from bottom
        // $this->SetY(-9);
        // $this->SetFont('Arial', 'I', 8);
        // Print centered page number
        // $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}


// $filename = './tmp/t' . rand(00000000, 99999999) . '.jpeg';
// if (file_exists($filename)) {
//     unlink($filename);
// }
// $img_o = base64_decode($response_std->nin_data->photo);
// $img =  imagecreatefromstring($img_o);
// imagejpeg($img, $filename);




$pdf = new PDF();

// $pdf->AddFont('ocr-a-bt', '', "C:/xamppp/htdocs/yamala_dash/print/fpdf/font/ocr-a-bt.php");
$pdf->AliasNbPages();
$pdf->AddPage('P', 'A4');
$pdf->SetFont('OCR-B 10 BT', '', 10);
$pdf->SetFillColor(240, 240, 255);
if ($response_std->nin_data->photo != '') {
    $filename = './tmp/t' . rand(00000000, 99999999) . '.jpeg';
    if (file_exists($filename)) {
        unlink($filename);
    }
    $img_o = base64_decode($response_std->nin_data->photo);
    $img =  imagecreatefromstring($img_o);
    imagejpeg($img, $filename);

    $pdf->Image($filename, 68, 63, 19, 25);
}
$pdf->Image($qr_file, 131, 55, 23, 22);
$pdf->Image("qr_temp/qr_center.png", 139, 62.5, 7);





$pdf->SetTextColor(160, 160, 160);
$pdf->SetFont('OCR-B 10 BT', '', 8);
$pdf->TextWithRotation(152, 80, $nin, 180);
$pdf->TextWithRotation(137, 93, $nin, 330);
$pdf->TextWithRotation(70, 103, $nin, 40);
$pdf->TextWithRotation(72, 95, $nin, 45);


$pdf->Ln(26);

$pdf->SetTextColor(0, 0, 0);
$pdf->Cell(78, 6, '', 0, 0, 'L', false);
$pdf->Cell(37, 6, '', 0, 0, 'L', false);
$pdf->SetFont('OCR-B 10 BT', '', 12);
$pdf->Cell(20.5, 6, '', 0, 1, 'C', false);
$pdf->SetFont('Arial', 'B', 11);
$pdf->TextWithRotation(139, 83, "NGA", 0);

$pdf->SetFont('Arial', 'B', 7);
$pdf->TextWithRotation(136.5, 87, "ISSUE DATE", 0);
$pdf->SetFont('OCR-B 10 BT', '', 8);
$pdf->TextWithRotation(134, 90, strtoupper($issue_date), 0);

$pdf->Ln(4);
$pdf->SetFont('OCR-B 10 BT', '', 8);

$pdf->Cell(80, 3, '', 0, 0, 'L', false);
$pdf->SetTextColor(130, 130, 130);
$pdf->SetFont('Arial', 'B', 6);
$pdf->Cell(37, 3, strtoupper('Surname/Nom'), 0, 0, 'L', false);
$pdf->Cell(20.5, 3, '', 0, 1, 'L', false);


$pdf->Cell(80, 3, '', 0, 0, 'L', false);

$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('OCR-B 10 BT', '', 8);
$pdf->Cell(37, 3, $response_std->nin_data->surname != "****" ? $response_std->nin_data->surname : '', 0, 0, 'L', false);
$pdf->Cell(20.5, 3, '', 0, 1, 'L', false);

$pdf->Ln(2);
$pdf->Cell(80, 3, '', 0, 0, 'L', false);
$pdf->SetTextColor(130, 130, 130);
$pdf->SetFont('Arial', 'B', 6);
$pdf->Cell(37, 3, strtoupper('Given Names/Prenoms'), 0, 0, 'L', false);
$pdf->Cell(20.5, 3, '', 0, 1, 'L', false);

$pdf->Cell(80, 3, '', 0, 0, 'L', false);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('OCR-B 10 BT', '', 8);
$pdf->Cell(37, 3, $response_std->nin_data->firstname . ($response_std->nin_data->middlename == "****" || $response_std->nin_data->middlename == '' ? '' : ", " . $response_std->nin_data->middlename), 0, 0, 'L', false);
$pdf->Cell(20.5, 3, '', 0, 1, 'L', false);
$pdf->Ln(2);

$pdf->Cell(80, 3, '', 0, 0, 'L', false);
$pdf->SetTextColor(130, 130, 130);
$pdf->SetFont('Arial', 'B', 6);
$pdf->Cell(24, 3, strtoupper('Date of Birth'), 0, 0, 'L', false);
$pdf->Cell(20.5, 3, 'SEX/SEXE', 0, 1, 'L', false);

$pdf->Cell(80, 3, '', 0, 0, 'L', false);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFont('OCR-B 10 BT', '', 8);
$pdf->Cell(24, 3, strtoupper($birthdate), 0, 0, 'L', false);
$pdf->Cell(20.5, 3, strtoupper($response_std->nin_data->gender), 0, 1, 'L', false);

$pdf->Ln(7);
$pdf->SetFont('Arial', 'B', 7);
$pdf->Cell(80, 3, '', 0, 0, 'L', false);
$pdf->Cell(39, 3, 'National Identification Number (NIN)', 0, 0, 'C', false);
$pdf->Cell(20.5, 3, '', 0, 1, 'L', false);


$pdf->Ln(2);
$pdf->SetFont('OCR-B 10 BT', '', 22);
$pdf->Cell(80, 3, '', 0, 0, 'L', false);
$pdf->Cell(39, 3, $sub1 . " " . $sub2 . " " . $sub3, 0, 1, 'C', false);

if (file_exists($filename)) {
    unlink($filename);
}

$doc_name = $nin . "_premium_nin_slip.pdf";
// ob_clean();

// $pdf->Output();
$pdf->Output("D", $doc_name);