<div class="p-2 sm:ml-64 mb-14">
    <nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-gray-700 border border-gray-200 rounded-lg bg-gray-50 dark:bg-cyan-800 dark:border-gray-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?=BASE_URL?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="#"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">NIN
                        Verifications</a>
                </div>
            </li>

        </ol>
    </nav>
    <div class="p-2 rounded-lg dark:border-gray-700">


        <h3 class="text-gray-400 text-sm">NIN Verification Services</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 items-center justify-center rounded py-4 ">

            <?php $services = Service::find_by_query("SELECT * FROM service WHERE category='NIN'");
            foreach ($services as $service):
            
                if ($user->role == 1 || ($service->display == 1)):
                ?>
                <a href="<?=BASE_URL?>/varifications/-verification_page/<?= $service->id ?>"
                    class="flex flex-col h-auto mb-2 p-4 text-cyan-800 bg-sky-200 transition-all shadow-sky-900 shadow-md rounded w-full hover:text-sky-600">
                    <div class="flex">
                        <div class="w-2/4 flex">

                            <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    style="fill: #0f5132;transform: ;msFilter:;">
                                    <path
                                        d="m2.394 13.742 4.743 3.62 7.616-8.704-1.506-1.316-6.384 7.296-3.257-2.486zm19.359-5.084-1.506-1.316-6.369 7.279-.753-.602-1.25 1.562 2.247 1.798z">
                                    </path>
                                </svg>
                            </div>
                            <span class="font-bold">
                                <?= $service->service_name ?>
                            </span>

                        </div>
                        <div class="w-2/4 flex justify-end text-[0.8rem] font-bold">
                            <div class="text-right">
                                <?php if ($service->status == 1): ?>
                                    <span
                                        class=" bg-[#d1e7dd] border border-[#badbcc] px-2 rounded text-[#0f5132] text-xs py-1 whitespace-nowrap">
                                        Service Available
                                    </span>
                                <?php else: ?>

                                    <span
                                        class=" bg-[#f8d7da] border border-[#f5c2c7] px-2 rounded text-[#842029] text-xs py-1 whitespace-nowrap">
                                        Service Shutdown
                                    </span>
                                <?php endif; ?>

                            </div>
                        </div>

                    </div>

                    <div class="flex flex-col my-3">
                        <span class="text-xs"><?= $service->description ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span
                            class="text-sm bg-cyan-800 text-white rounded py-1 px-2 whitespace-nowrap hover:scale-105">Use Service</span>
                        <div class="text-right">
                            <!-- <span class=" bg-[#d1e7dd] border border-[#badbcc] px-5 rounded text-[#0f5132] text-xs py-1 ">
                                ₦
                                <?= $service->service_fee ?>
                            </span> -->
                        </div>

                    </div>

                                </a>

            <?php endif; ?>
            <?php endforeach; ?>




        </div>

    </div>
</div>