<div class="p-2 sm:ml-64 mb-14">
    <nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-cyan-700 border border-cyan-200 rounded-lg bg-cyan-50 dark:bg-cyan-800 dark:border-cyan-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="#"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">Profile</a>
                </div>
            </li>

        </ol>
    </nav>


    <div class="p-2 rounded-lg dark:border-gray-700">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4 ">

            <div
                class="relative flex flex-col h-full min-w-0 break-words bg-sky-800 border-0 shadow-soft-xl rounded bg-clip-border">
                <div class="p-4 pb-0 mb-0 bg-sky-800 border-b-0 rounded-t">
                    <div class="flex flex-wrap -mx-3">
                        <div class="flex items-center w-full max-w-full px-3 shrink-0 md:w-8/12 md:flex-none">
                            <h6 class="mb-0 text-white">Profile Information</h6>
                        </div>
                        <div id="edit_profile_btn"
                            class="w-full max-w-full px-3 text-right shrink-0 md:w-4/12 md:flex-none rounded-lg shadow-soft-lg bg-sky-950 text-white">
                            <a href="javascript:;" data-target="tooltip_trigger" data-placement="top">
                                <i class="leading-normal fas fa-user-edit text-sm text-white"></i>&nbsp; Edit
                                Profile
                            </a>
                            <div data-target="tooltip"
                                class="hidden px-2 py-1 text-center text-white bg-black rounded-lg text-sm"
                                role="tooltip">
                                Edit Profile
                                <div class="invisible absolute h-2 w-2 bg-inherit before:visible before:absolute before:h-2 before:w-2 before:rotate-45 before:bg-inherit before:content-['']"
                                    data-popper-arrow></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-auto p-4">
                    <span class="msg"></span>
                    <h3 class='text-gray-400'>
                        <?= strtoupper($user->first_name . " " . $user->last_name) ?>

                    </h3>
                    <form id="update_profile_form" action="" method="post">
                        <table class="table table-flush text-white text-sm">
                            <tr>
                                <th>Email Address</th>
                                <td>
                                    <?= $user->email ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Phone Number</th>
                                <td>
                                    <?= $user->phone ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Address</th>
                                <td>
                                    <textarea required disabled class="form-control" name="address" id="address"
                                        rows="4"><?= $user->address ?></textarea>
                                </td>
                            </tr>
                            <tr>
                                <th>Password</th>
                                <td>
                                    <input required disabled class="form-control" type="password" name="password"
                                        id="password" value="<?= $user->password ?>">
                                </td>
                            </tr>
                            <tr>
                                <th>Confirm Password</th>
                                <td>
                                    <input required disabled class="form-control" type="password" name="confirm_pass"
                                        id="confirm_pass" value="">
                                </td>
                            </tr>
                        </table>
                        <!-- <br> -->
                        <button type="submit" style="display: none;" id="save_btn"
                            class="btn btn-theme m-2 rounded-lg text-white bg-gradient-to-tl from-green-600 to-lime-400"><i
                                class="fa fa-save"></i>
                            Update</button>

                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $("#edit_profile_btn").click(function () {
            $("#save_btn").css({
                "display": ""
            })

            $(this).hide()


            $("#address").prop("disabled", false)
            $("#password").prop("disabled", false)
            $("#confirm_pass").prop("disabled", false)

        })
    })
    $(document).on("submit", "#update_profile_form", function (e) {

        e.preventDefault()
        var address = $("#address").val()
        var password = $("#password").val()
        var confirm_pass = $("#confirm_pass").val()


        if (address == "") {
            iziToast.show({
                title: 'Error!',
                message: "Address Field Cannot be Empty",
                color: "yellow",
                position: "topRight",
                balloon: true
            });

            return false
        }

        if (password.length < 6) {

            iziToast.show({
                title: 'Error!',
                message: "Password length must be at least 6 characters",
                color: "yellow",
                position: "topRight",
                balloon: true
            });

            return false
        }
        if (confirm_pass != password) {

            iziToast.show({
                title: 'Error!',
                message: "Password do not match",
                color: "yellow",
                position: "topRight",
                balloon: true
            });


            return false
        }

        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "includes/components/save_profile.php",
            data: $(this).serialize(),
            success: function (response) {
                // console.log(response)
                if (response.response_code == "00") {

                    iziToast.show({
                        title: 'Done!',
                        message: "Profile Updated Successfuly",
                        color: "green",
                        position: "center",
                        balloon: true
                    });


                } else {

                    iziToast.show({
                        title: 'Error!',
                        message: response.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });

                }
            },
            error: function (error) {
                // console.log(error)
                if (error) {
                    var res = JSON.parse(error.responseText)

                    iziToast.show({
                        title: 'Error!',
                        message: res.message,
                        color: "red",
                        position: "topRight",
                        balloon: true
                    });

                }
            }
        }).done(function () {
            $("#save_btn").css({
                "display": "none"
            })

            $("#edit_profile_btn").show()

            $("#address").prop("disabled", true)
            $("#password").prop("disabled", true)
            $("#confirm_pass").prop("disabled", true)

        })



    })
</script>