<?php
$my_intransactions = InTransaction::find_by_query("SELECT * FROM in_transaction WHERE user_id =$user->id  ORDER BY id DESC");
$his_payments = Payment::find_by_query("SELECT * FROM payment WHERE user_id =$user->id ORDER BY id DESC");
?>


<div class="p-2 sm:ml-64 mb-14">
<nav class="md:max-w-max flex px-5 py-2 mt-20 mx-2 text-cyan-700 border border-cyan-200 rounded-lg bg-cyan-50 dark:bg-cyan-800 dark:border-cyan-700"
        aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?= BASE_URL ?>"
                    class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600 dark:text-gray-400 dark:hover:text-white">
                    <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="currentColor" viewBox="0 0 20 20">
                        <path
                            d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z" />
                    </svg>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-3 h-3 mx-1 text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                    <a href="<?= BASE_URL ?>/users"
                        class="ml-1 text-sm font-medium text-gray-700 hover:text-blue-600 md:ml-2 dark:text-gray-400 dark:hover:text-white">Transactions</a>
                </div>
            </li>

        </ol>
    </nav>


    <div class="p-2 rounded-lg dark:border-gray-700 mt">


        <h3 class="text-gray-400">Wallet Topup History</h3>

        <div
            class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 items-center justify-center rounded py-4 ">

            <?php foreach ($his_payments as $his_payment): 
               
                ?>
                <div
                    class="flex flex-col h-auto mb-2 p-2 text-gray-800 bg-sky-200 hover:scale-y-105 transition-all shadow-sky-900 shadow-md rounded w-full cursor-pointer">
                    <div class="flex">
                        <div class="w-3/4 flex">

                            <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24"
                                    style="fill: #0b9152;transform: ;msFilter:;">
                                    <path
                                        d="M8 12.052c1.995 0 3.5-1.505 3.5-3.5s-1.505-3.5-3.5-3.5-3.5 1.505-3.5 3.5 1.505 3.5 3.5 3.5zM9 13H7c-2.757 0-5 2.243-5 5v1h12v-1c0-2.757-2.243-5-5-5zm11.294-4.708-4.3 4.292-1.292-1.292-1.414 1.414 2.706 2.704 5.712-5.702z">
                                    </path>
                                </svg>
                            </div>

                            <div class="flex flex-col">
                                <span class="font-bold text-sm">Wallet Top-up</span>
                                <span class="text-xs">
                                    TRX-<?= $his_payment->reference ?><br>
                                    <?= $his_payment->date_created ?>
                                </span>
                            </div>
                        </div>
                        <div class="w-1/4 flex justify-end text-[#0f5132] text-[0.8rem] font-bold whitespace-nowrap">
                            + ₦
                            <?= number_format($his_payment->amount) ?>
                        </div>
                    </div>
                    <div class="text-right">
                        <span class=" bg-[#d1e7dd] border border-[#badbcc] px-2 rounded text-[#0f5132] text-xs py-1 whitespace-nowrap">
                            Successful
                        </span>
                    </div>

                </div>
            <?php endforeach ?>

        </div>

        <h3 class="text-gray-400">Searches History</h3>

        <div
            class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 items-center justify-center rounded py-4 ">

            <?php foreach ($my_intransactions as $my_intransaction): 
                 if($my_intransaction->service_id !=0 || $my_intransaction->status==0):
                    $parent_service=Service::find_by_id($my_intransaction->service_id);
                    // $service = $my_intransaction->service_id !=0 ?  $parent_service->service_name ." > " .$my_intransaction->service: $my_intransaction->service;
                    
                    if($my_intransaction->service_id !=0){
                        $service= Service::find_by_id($my_intransaction->service_id);
                            $service_name = $parent_service->service_name ." > " .$my_intransaction->service;
                            $amount = intval($parent_service->service_fee)+intval($my_intransaction->amount);
                    }else{
                        $service_name = $my_intransaction->service;
                        $amount =intval($my_intransaction->amount);
                    }

                ?>
                <div
                    class="flex flex-col h-auto mb-2 p-2 text-gray-800 bg-sky-200 hover:scale-y-105 transition-all shadow-sky-900 shadow-md rounded w-full cursor-pointer">
                    <div class="flex">
                        <div class="w-3/4 flex">

                            <div class="rounded-full bg-white p-2 w-10 h-10 flex items-center justify-center mr-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24"
                                    style="fill: #0b9152;transform: ;msFilter:;">
                                    <path
                                        d="M8 12.052c1.995 0 3.5-1.505 3.5-3.5s-1.505-3.5-3.5-3.5-3.5 1.505-3.5 3.5 1.505 3.5 3.5 3.5zM9 13H7c-2.757 0-5 2.243-5 5v1h12v-1c0-2.757-2.243-5-5-5zm11.294-4.708-4.3 4.292-1.292-1.292-1.414 1.414 2.706 2.704 5.712-5.702z">
                                    </path>
                                </svg>
                            </div>

                            <div class="flex flex-col">
                                <span class="font-bold text-sm">
                                    <?= $service_name ?> >
                                    <?= ''//$my_intransaction->service ?>
                                </span>
                                <span class="text-xs">
                                    <?= $my_intransaction->search_query ?><br>
                                    <?= $my_intransaction->date ?>
                                </span>
                            </div>
                        </div>
                        <div class="w-1/4 flex justify-end text-[#842029] text-[0.8rem] font-bold">
                            - ₦
                            <?= number_format($amount) ?>
                        </div>
                    </div>
                    <div class="text-right">
                        <?php if ($my_intransaction->status == 1): ?>
                            <span class=" bg-[#d1e7dd] border border-[#badbcc] px-5 rounded text-[#0f5132] text-xs py-1 ">
                                Successful
                            </span>
                        <?php else: ?>
                            <span class=" bg-[#f8d7da] border border-[#f5c2c7] px-5 rounded text-[#842029] text-xs py-1 ">
                                Failed
                            </span>

                        <?php endif ?>
                    </div>

                </div>
            <?php endif; endforeach ?>
        </div>

    </div>
</div>